/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.objects;

import com.bulletphysics.dynamics.RigidBody;
import com.bulletphysics.dynamics.RigidBodyConstructionInfo;
import com.bulletphysics.linearmath.MotionState;
import com.bulletphysics.linearmath.Transform;
import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.collision.PhysicsCollisionObject;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.collision.shapes.MeshCollisionShape;
import com.jme3.bullet.joints.PhysicsJoint;
import com.jme3.bullet.objects.infos.RigidBodyMotionState;
import com.jme3.bullet.util.Converter;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Matrix3f;

public class PhysicsRigidBody
extends PhysicsCollisionObject {
    protected RigidBodyConstructionInfo constructionInfo;
    protected RigidBody rBody;
    protected RigidBodyMotionState motionState = new RigidBodyMotionState();
    protected float mass = 1.0f;
    protected boolean kinematic = false;
    protected javax.vecmath.Vector3f tempVec = new javax.vecmath.Vector3f();
    protected javax.vecmath.Vector3f tempVec2 = new javax.vecmath.Vector3f();
    protected Transform tempTrans = new Transform(new Matrix3f());
    protected Matrix3f tempMatrix = new Matrix3f();
    protected javax.vecmath.Vector3f localInertia = new javax.vecmath.Vector3f();
    protected ArrayList<PhysicsJoint> joints = new ArrayList();

    protected PhysicsRigidBody() {
    }

    public PhysicsRigidBody(CollisionShape shape) {
        this.collisionShape = shape;
        this.rebuildRigidBody();
    }

    public PhysicsRigidBody(CollisionShape shape, float mass) {
        this.collisionShape = shape;
        this.mass = mass;
        this.rebuildRigidBody();
    }

    protected void rebuildRigidBody() {
        boolean removed = false;
        if (this.collisionShape instanceof MeshCollisionShape && this.mass != 0.0f) {
            throw new IllegalStateException("Dynamic rigid body cannot have mesh collision shape!");
        }
        if (this.rBody != null) {
            if (this.rBody.isInWorld()) {
                PhysicsSpace.getPhysicsSpace().remove(this);
                removed = true;
            }
            this.rBody.destroy();
        }
        this.preRebuild();
        this.rBody = new RigidBody(this.constructionInfo);
        this.postRebuild();
        if (removed) {
            PhysicsSpace.getPhysicsSpace().add(this);
        }
    }

    protected void preRebuild() {
        this.collisionShape.calculateLocalInertia(this.mass, this.localInertia);
        if (this.constructionInfo == null) {
            this.constructionInfo = new RigidBodyConstructionInfo(this.mass, (MotionState)this.motionState, this.collisionShape.getCShape(), this.localInertia);
        } else {
            this.constructionInfo.mass = this.mass;
            this.constructionInfo.collisionShape = this.collisionShape.getCShape();
            this.constructionInfo.motionState = this.motionState;
        }
    }

    protected void postRebuild() {
        this.rBody.setUserPointer((Object)this);
        if (this.mass == 0.0f) {
            this.rBody.setCollisionFlags(this.rBody.getCollisionFlags() | 1);
        } else {
            this.rBody.setCollisionFlags(this.rBody.getCollisionFlags() & 0xFFFFFFFE);
        }
    }

    public RigidBodyMotionState getMotionState() {
        return this.motionState;
    }

    public void setPhysicsLocation(Vector3f location) {
        this.rBody.getCenterOfMassTransform(this.tempTrans);
        Converter.convert(location, this.tempTrans.origin);
        this.rBody.setCenterOfMassTransform(this.tempTrans);
        this.motionState.setWorldTransform(this.tempTrans);
    }

    public void setPhysicsRotation(com.jme3.math.Matrix3f rotation) {
        this.rBody.getCenterOfMassTransform(this.tempTrans);
        Converter.convert(rotation, this.tempTrans.basis);
        this.rBody.setCenterOfMassTransform(this.tempTrans);
        this.motionState.setWorldTransform(this.tempTrans);
    }

    public void setPhysicsRotation(Quaternion rotation) {
        this.rBody.getCenterOfMassTransform(this.tempTrans);
        Converter.convert(rotation, this.tempTrans.basis);
        this.rBody.setCenterOfMassTransform(this.tempTrans);
        this.motionState.setWorldTransform(this.tempTrans);
    }

    public Vector3f getPhysicsLocation() {
        return this.getPhysicsLocation(null);
    }

    public com.jme3.math.Matrix3f getPhysicsRotationMatrix() {
        return this.getPhysicsRotationMatrix(null);
    }

    public Vector3f getPhysicsLocation(Vector3f location) {
        if (location == null) {
            location = new Vector3f();
        }
        this.rBody.getCenterOfMassTransform(this.tempTrans);
        return Converter.convert(this.tempTrans.origin, location);
    }

    public com.jme3.math.Matrix3f getPhysicsRotationMatrix(com.jme3.math.Matrix3f rotation) {
        if (rotation == null) {
            rotation = new com.jme3.math.Matrix3f();
        }
        this.rBody.getCenterOfMassTransform(this.tempTrans);
        return Converter.convert(this.tempTrans.basis, rotation);
    }

    public Quaternion getPhysicsRotation() {
        return this.getPhysicsRotation(null);
    }

    public Quaternion getPhysicsRotation(Quaternion rotation) {
        if (rotation == null) {
            rotation = new Quaternion();
        }
        this.rBody.getCenterOfMassTransform(this.tempTrans);
        return Converter.convert(this.tempTrans.basis, rotation);
    }

    public Vector3f getInterpolatedPhysicsLocation(Vector3f location) {
        if (location == null) {
            location = new Vector3f();
        }
        this.rBody.getInterpolationWorldTransform(this.tempTrans);
        return Converter.convert(this.tempTrans.origin, location);
    }

    public com.jme3.math.Matrix3f getInterpolatedPhysicsRotation(com.jme3.math.Matrix3f rotation) {
        if (rotation == null) {
            rotation = new com.jme3.math.Matrix3f();
        }
        this.rBody.getInterpolationWorldTransform(this.tempTrans);
        return Converter.convert(this.tempTrans.basis, rotation);
    }

    public void setKinematic(boolean kinematic) {
        this.kinematic = kinematic;
        if (kinematic) {
            this.rBody.setCollisionFlags(this.rBody.getCollisionFlags() | 2);
            this.rBody.setActivationState(4);
        } else {
            this.rBody.setCollisionFlags(this.rBody.getCollisionFlags() & 0xFFFFFFFD);
            this.rBody.setActivationState(1);
        }
    }

    public boolean isKinematic() {
        return this.kinematic;
    }

    public void setContactResponse(boolean responsive) {
        int flags = this.rBody.getCollisionFlags();
        flags = responsive ? (flags &= 0xFFFFFFFB) : (flags |= 4);
        this.rBody.setCollisionFlags(flags);
    }

    public boolean isContactResponse() {
        int flags = this.rBody.getCollisionFlags();
        boolean result = (flags & 4) == 0;
        return result;
    }

    public void setCcdSweptSphereRadius(float radius) {
        this.rBody.setCcdSweptSphereRadius(radius);
    }

    public void setCcdMotionThreshold(float threshold) {
        this.rBody.setCcdMotionThreshold(threshold);
    }

    public float getCcdSweptSphereRadius() {
        return this.rBody.getCcdSweptSphereRadius();
    }

    public float getCcdMotionThreshold() {
        return this.rBody.getCcdMotionThreshold();
    }

    public float getCcdSquareMotionThreshold() {
        return this.rBody.getCcdSquareMotionThreshold();
    }

    public float getMass() {
        return this.mass;
    }

    public void setMass(float mass) {
        this.mass = mass;
        if (this.collisionShape instanceof MeshCollisionShape && mass != 0.0f) {
            throw new IllegalStateException("Dynamic rigid body cannot have mesh collision shape!");
        }
        if (this.collisionShape != null) {
            this.collisionShape.calculateLocalInertia(mass, this.localInertia);
        }
        if (this.rBody != null) {
            this.rBody.setMassProps(mass, this.localInertia);
            if (mass == 0.0f) {
                this.rBody.setCollisionFlags(this.rBody.getCollisionFlags() | 1);
            } else {
                this.rBody.setCollisionFlags(this.rBody.getCollisionFlags() & 0xFFFFFFFE);
            }
        }
    }

    public Vector3f getGravity() {
        return this.getGravity(null);
    }

    public Vector3f getGravity(Vector3f gravity) {
        if (gravity == null) {
            gravity = new Vector3f();
        }
        this.rBody.getGravity(this.tempVec);
        return Converter.convert(this.tempVec, gravity);
    }

    public void setGravity(Vector3f gravity) {
        this.rBody.setGravity(Converter.convert(gravity, this.tempVec));
    }

    public float getFriction() {
        return this.rBody.getFriction();
    }

    public void setFriction(float friction) {
        this.constructionInfo.friction = friction;
        this.rBody.setFriction(friction);
    }

    public void setDamping(float linearDamping, float angularDamping) {
        this.constructionInfo.linearDamping = linearDamping;
        this.constructionInfo.angularDamping = angularDamping;
        this.rBody.setDamping(linearDamping, angularDamping);
    }

    public void setLinearDamping(float linearDamping) {
        this.constructionInfo.linearDamping = linearDamping;
        this.rBody.setDamping(linearDamping, this.constructionInfo.angularDamping);
    }

    public void setAngularDamping(float angularDamping) {
        this.constructionInfo.angularDamping = angularDamping;
        this.rBody.setDamping(this.constructionInfo.linearDamping, angularDamping);
    }

    public float getLinearDamping() {
        return this.constructionInfo.linearDamping;
    }

    public float getAngularDamping() {
        return this.constructionInfo.angularDamping;
    }

    public float getRestitution() {
        return this.rBody.getRestitution();
    }

    public void setRestitution(float restitution) {
        this.constructionInfo.restitution = restitution;
        this.rBody.setRestitution(restitution);
    }

    public Vector3f getAngularVelocity() {
        return Converter.convert(this.rBody.getAngularVelocity(this.tempVec));
    }

    public void getAngularVelocity(Vector3f vec) {
        Converter.convert(this.rBody.getAngularVelocity(this.tempVec), vec);
    }

    public void setAngularVelocity(Vector3f vec) {
        this.rBody.setAngularVelocity(Converter.convert(vec, this.tempVec));
        this.rBody.activate();
    }

    public Vector3f getLinearVelocity() {
        return Converter.convert(this.rBody.getLinearVelocity(this.tempVec));
    }

    public void getLinearVelocity(Vector3f vec) {
        Converter.convert(this.rBody.getLinearVelocity(this.tempVec), vec);
    }

    public void setLinearVelocity(Vector3f vec) {
        this.rBody.setLinearVelocity(Converter.convert(vec, this.tempVec));
        this.rBody.activate();
    }

    public void applyForce(Vector3f force, Vector3f location) {
        this.rBody.applyForce(Converter.convert(force, this.tempVec), Converter.convert(location, this.tempVec2));
        this.rBody.activate();
    }

    public void applyCentralForce(Vector3f force) {
        this.rBody.applyCentralForce(Converter.convert(force, this.tempVec));
        this.rBody.activate();
    }

    public void applyTorque(Vector3f torque) {
        this.rBody.applyTorque(Converter.convert(torque, this.tempVec));
        this.rBody.activate();
    }

    public void applyImpulse(Vector3f impulse, Vector3f relativePosition) {
        this.rBody.applyImpulse(Converter.convert(impulse, this.tempVec), Converter.convert(relativePosition, this.tempVec2));
        this.rBody.activate();
    }

    public void applyTorqueImpulse(Vector3f vec) {
        this.rBody.applyTorqueImpulse(Converter.convert(vec, this.tempVec));
        this.rBody.activate();
    }

    public void clearForces() {
        this.rBody.clearForces();
    }

    @Override
    public void setCollisionShape(CollisionShape collisionShape) {
        super.setCollisionShape(collisionShape);
        if (collisionShape instanceof MeshCollisionShape && this.mass != 0.0f) {
            throw new IllegalStateException("Dynamic rigid body cannot have mesh collision shape!");
        }
        if (this.rBody == null) {
            this.rebuildRigidBody();
        } else {
            collisionShape.calculateLocalInertia(this.mass, this.localInertia);
            this.constructionInfo.collisionShape = collisionShape.getCShape();
            this.rBody.setCollisionShape(collisionShape.getCShape());
        }
    }

    public void activate() {
        this.rBody.activate();
    }

    public boolean isActive() {
        return this.rBody.isActive();
    }

    public void setSleepingThresholds(float linear, float angular) {
        this.constructionInfo.linearSleepingThreshold = linear;
        this.constructionInfo.angularSleepingThreshold = angular;
        this.rBody.setSleepingThresholds(linear, angular);
    }

    public void setLinearSleepingThreshold(float linearSleepingThreshold) {
        this.constructionInfo.linearSleepingThreshold = linearSleepingThreshold;
        this.rBody.setSleepingThresholds(linearSleepingThreshold, this.constructionInfo.angularSleepingThreshold);
    }

    public void setAngularSleepingThreshold(float angularSleepingThreshold) {
        this.constructionInfo.angularSleepingThreshold = angularSleepingThreshold;
        this.rBody.setSleepingThresholds(this.constructionInfo.linearSleepingThreshold, angularSleepingThreshold);
    }

    public float getLinearSleepingThreshold() {
        return this.constructionInfo.linearSleepingThreshold;
    }

    public float getAngularSleepingThreshold() {
        return this.constructionInfo.angularSleepingThreshold;
    }

    public float getAngularFactor() {
        return this.rBody.getAngularFactor();
    }

    public void setAngularFactor(float factor) {
        this.rBody.setAngularFactor(factor);
    }

    public void addJoint(PhysicsJoint joint) {
        if (!this.joints.contains(joint)) {
            this.joints.add(joint);
        }
    }

    public void removeJoint(PhysicsJoint joint) {
        this.joints.remove(joint);
    }

    public List<PhysicsJoint> getJoints() {
        return this.joints;
    }

    public RigidBody getObjectId() {
        return this.rBody;
    }

    public void destroy() {
        this.rBody.destroy();
    }

    @Override
    public void write(JmeExporter e) throws IOException {
        super.write(e);
        OutputCapsule capsule = e.getCapsule((Savable)this);
        capsule.write(this.getMass(), "mass", 1.0f);
        capsule.write((Savable)this.getGravity(), "gravity", (Savable)Vector3f.ZERO);
        capsule.write(this.getFriction(), "friction", 0.5f);
        capsule.write(this.getRestitution(), "restitution", 0.0f);
        capsule.write(this.getAngularFactor(), "angularFactor", 1.0f);
        capsule.write(this.kinematic, "kinematic", false);
        capsule.write(this.constructionInfo.linearDamping, "linearDamping", 0.0f);
        capsule.write(this.constructionInfo.angularDamping, "angularDamping", 0.0f);
        capsule.write(this.constructionInfo.linearSleepingThreshold, "linearSleepingThreshold", 0.8f);
        capsule.write(this.constructionInfo.angularSleepingThreshold, "angularSleepingThreshold", 1.0f);
        capsule.write(this.getCcdMotionThreshold(), "ccdMotionThreshold", 0.0f);
        capsule.write(this.getCcdSweptSphereRadius(), "ccdSweptSphereRadius", 0.0f);
        capsule.write((Savable)this.getPhysicsLocation(new Vector3f()), "physicsLocation", (Savable)new Vector3f());
        capsule.write((Savable)this.getPhysicsRotationMatrix(new com.jme3.math.Matrix3f()), "physicsRotation", (Savable)new com.jme3.math.Matrix3f());
        capsule.write((Savable)this.getLinearVelocity(), "linearVelocity", null);
        capsule.write((Savable)this.getAngularVelocity(), "angularVelocity", null);
        capsule.writeSavableArrayList(this.joints, "joints", null);
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        float mass;
        super.read(importer);
        InputCapsule capsule = importer.getCapsule((Savable)this);
        this.mass = mass = capsule.readFloat("mass", 1.0f);
        this.rebuildRigidBody();
        this.setGravity((Vector3f)capsule.readSavable("gravity", (Savable)Vector3f.ZERO.clone()));
        this.setContactResponse(capsule.readBoolean("contactResponse", true));
        this.setFriction(capsule.readFloat("friction", 0.5f));
        this.setKinematic(capsule.readBoolean("kinematic", false));
        this.setRestitution(capsule.readFloat("restitution", 0.0f));
        this.setAngularFactor(capsule.readFloat("angularFactor", 1.0f));
        this.setDamping(capsule.readFloat("linearDamping", 0.0f), capsule.readFloat("angularDamping", 0.0f));
        this.setSleepingThresholds(capsule.readFloat("linearSleepingThreshold", 0.8f), capsule.readFloat("angularSleepingThreshold", 1.0f));
        this.setCcdMotionThreshold(capsule.readFloat("ccdMotionThreshold", 0.0f));
        this.setCcdSweptSphereRadius(capsule.readFloat("ccdSweptSphereRadius", 0.0f));
        this.setPhysicsLocation((Vector3f)capsule.readSavable("physicsLocation", (Savable)new Vector3f()));
        this.setPhysicsRotation((com.jme3.math.Matrix3f)capsule.readSavable("physicsRotation", (Savable)new com.jme3.math.Matrix3f()));
        this.setLinearVelocity((Vector3f)capsule.readSavable("linearVelocity", (Savable)new Vector3f()));
        this.setAngularVelocity((Vector3f)capsule.readSavable("angularVelocity", (Savable)new Vector3f()));
        this.joints = capsule.readSavableArrayList("joints", null);
    }
}

