/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision;

import com.bulletphysics.collision.narrowphase.ManifoldPoint;
import com.jme3.bullet.collision.PhysicsCollisionObject;
import com.jme3.bullet.util.Converter;
import com.jme3.math.Vector3f;
import com.jme3.scene.Spatial;
import java.util.EventObject;

public class PhysicsCollisionEvent
extends EventObject {
    public static final int TYPE_ADDED = 0;
    public static final int TYPE_PROCESSED = 1;
    public static final int TYPE_DESTROYED = 2;
    private int type;
    private PhysicsCollisionObject nodeA;
    private PhysicsCollisionObject nodeB;
    private ManifoldPoint cp;

    public PhysicsCollisionEvent(int type, PhysicsCollisionObject source, PhysicsCollisionObject nodeB, ManifoldPoint cp) {
        super(source);
        this.type = type;
        this.nodeA = source;
        this.nodeB = nodeB;
        this.cp = cp;
    }

    public void clean() {
        this.source = null;
        this.type = 0;
        this.nodeA = null;
        this.nodeB = null;
        this.cp = null;
    }

    public void refactor(int type, PhysicsCollisionObject source, PhysicsCollisionObject nodeB, ManifoldPoint cp) {
        this.source = source;
        this.type = type;
        this.nodeA = source;
        this.nodeB = nodeB;
        this.cp = cp;
    }

    public int getType() {
        return this.type;
    }

    public Spatial getNodeA() {
        if (this.nodeA.getUserObject() instanceof Spatial) {
            return (Spatial)this.nodeA.getUserObject();
        }
        return null;
    }

    public Spatial getNodeB() {
        if (this.nodeB.getUserObject() instanceof Spatial) {
            return (Spatial)this.nodeB.getUserObject();
        }
        return null;
    }

    public PhysicsCollisionObject getObjectA() {
        return this.nodeA;
    }

    public PhysicsCollisionObject getObjectB() {
        return this.nodeB;
    }

    public float getAppliedImpulse() {
        return this.cp.appliedImpulse;
    }

    public float getAppliedImpulseLateral1() {
        return this.cp.appliedImpulseLateral1;
    }

    public float getAppliedImpulseLateral2() {
        return this.cp.appliedImpulseLateral2;
    }

    public float getCombinedFriction() {
        return this.cp.combinedFriction;
    }

    public float getCombinedRestitution() {
        return this.cp.combinedRestitution;
    }

    public float getDistance1() {
        return this.cp.distance1;
    }

    public int getIndex0() {
        return this.cp.index0;
    }

    public int getIndex1() {
        return this.cp.index1;
    }

    public Vector3f getLateralFrictionDir1() {
        return Converter.convert(this.cp.lateralFrictionDir1);
    }

    public Vector3f getLateralFrictionDir2() {
        return Converter.convert(this.cp.lateralFrictionDir2);
    }

    public boolean isLateralFrictionInitialized() {
        return this.cp.lateralFrictionInitialized;
    }

    public int getLifeTime() {
        return this.cp.lifeTime;
    }

    public Vector3f getLocalPointA() {
        return Converter.convert(this.cp.localPointA);
    }

    public Vector3f getLocalPointB() {
        return Converter.convert(this.cp.localPointB);
    }

    public Vector3f getNormalWorldOnB() {
        return Converter.convert(this.cp.normalWorldOnB);
    }

    public int getPartId0() {
        return this.cp.partId0;
    }

    public int getPartId1() {
        return this.cp.partId1;
    }

    public Vector3f getPositionWorldOnA() {
        return Converter.convert(this.cp.positionWorldOnA);
    }

    public Vector3f getPositionWorldOnB() {
        return Converter.convert(this.cp.positionWorldOnB);
    }

    public Object getUserPersistentData() {
        return this.cp.userPersistentData;
    }
}

