/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.animation;

import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.animation.BoneLink;
import com.jme3.bullet.animation.DacLinks;
import com.jme3.bullet.animation.KinematicSubmode;
import com.jme3.bullet.animation.PhysicsLink;
import com.jme3.bullet.animation.RagdollCollisionListener;
import com.jme3.bullet.animation.TorsoLink;
import com.jme3.bullet.collision.PhysicsCollisionEvent;
import com.jme3.bullet.collision.PhysicsCollisionListener;
import com.jme3.bullet.collision.PhysicsCollisionObject;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.util.SafeArrayList;
import com.jme3.util.clone.Cloner;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;

public class DynamicAnimControl
extends DacLinks
implements PhysicsCollisionListener {
    public static final Logger logger35 = Logger.getLogger(DynamicAnimControl.class.getName());
    private float ragdollMass = 0.0f;
    private List<RagdollCollisionListener> collisionListeners = new SafeArrayList(RagdollCollisionListener.class);
    private Vector3f centerLocation = new Vector3f();
    private Vector3f centerVelocity = new Vector3f();

    public void addCollisionListener(RagdollCollisionListener listener) {
        this.collisionListeners.add(listener);
    }

    public void animateSubtree(PhysicsLink rootLink, float blendInterval) {
        this.verifyAddedToSpatial("change modes");
        this.blendSubtree(rootLink, KinematicSubmode.Animated, blendInterval);
    }

    public void blendToKinematicMode(float blendInterval, Transform endModelTransform) {
        this.verifyAddedToSpatial("change modes");
        this.getTorsoLink().blendToKinematicMode(KinematicSubmode.Animated, blendInterval, endModelTransform);
        for (BoneLink boneLink : this.getBoneLinks()) {
            boneLink.blendToKinematicMode(KinematicSubmode.Animated, blendInterval);
        }
    }

    public float centerOfMass(Vector3f storeLocation, Vector3f storeVelocity) {
        this.verifyReadyForDynamicMode("calculate the center of mass");
        this.recalculateCenter();
        if (storeLocation != null) {
            storeLocation.set(this.centerLocation);
        }
        if (storeVelocity != null) {
            storeVelocity.set(this.centerVelocity);
        }
        return this.ragdollMass;
    }

    public void setContactResponseSubtree(PhysicsLink rootLink, boolean desiredResponse) {
        PhysicsLink[] children;
        this.verifyAddedToSpatial("change modes");
        PhysicsRigidBody rigidBody = rootLink.getRigidBody();
        rigidBody.setContactResponse(desiredResponse);
        for (PhysicsLink child : children = rootLink.listChildren()) {
            this.setContactResponseSubtree(child, desiredResponse);
        }
    }

    public void setDynamicChain(PhysicsLink startLink, int chainLength, Vector3f uniformAcceleration) {
        PhysicsLink parent;
        if (chainLength == 0) {
            return;
        }
        this.verifyAddedToSpatial("change modes");
        if (startLink instanceof BoneLink) {
            BoneLink boneLink = (BoneLink)startLink;
            boneLink.setDynamic(uniformAcceleration);
        }
        if ((parent = startLink.getParent()) != null && chainLength > 1) {
            this.setDynamicChain(parent, chainLength - 1, uniformAcceleration);
        }
    }

    public void setDynamicSubtree(PhysicsLink rootLink, Vector3f uniformAcceleration) {
        PhysicsLink[] children;
        this.verifyAddedToSpatial("change modes");
        if (rootLink == this.getTorsoLink()) {
            this.getTorsoLink().setDynamic(uniformAcceleration);
        } else if (rootLink instanceof BoneLink) {
            BoneLink boneLink = (BoneLink)rootLink;
            boneLink.setDynamic(uniformAcceleration);
        }
        for (PhysicsLink child : children = rootLink.listChildren()) {
            this.setDynamicSubtree(child, uniformAcceleration);
        }
    }

    public void setKinematicMode() {
        this.verifyAddedToSpatial("set kinematic mode");
        Transform localTransform = this.getSpatial().getLocalTransform();
        this.blendToKinematicMode(0.0f, localTransform);
    }

    public void setRagdollMode() {
        this.verifyReadyForDynamicMode("set ragdoll mode");
        TorsoLink torsoLink = this.getTorsoLink();
        Vector3f acceleration = this.gravity(null);
        torsoLink.setDynamic(acceleration);
        for (BoneLink boneLink : this.getBoneLinks()) {
            boneLink.setDynamic(acceleration);
        }
    }

    @Override
    protected void addPhysics(PhysicsSpace space) {
        super.addPhysics(space);
        space.addCollisionListener(this);
        space.addTickListener(this);
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        super.cloneFields(cloner, original);
        this.collisionListeners = (List)cloner.clone(this.collisionListeners);
        this.centerLocation = (Vector3f)cloner.clone((Object)this.centerLocation);
        this.centerVelocity = (Vector3f)cloner.clone((Object)this.centerVelocity);
    }

    @Override
    public DynamicAnimControl jmeClone() {
        try {
            DynamicAnimControl clone = (DynamicAnimControl)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule((Savable)this);
        this.ragdollMass = ic.readFloat("ragdollMass", 1.0f);
        this.centerLocation = (Vector3f)ic.readSavable("centerLocation", (Savable)new Vector3f());
        this.centerVelocity = (Vector3f)ic.readSavable("centerVelocity", (Savable)new Vector3f());
    }

    @Override
    protected void removePhysics(PhysicsSpace space) {
        super.removePhysics(space);
        space.removeCollisionListener(this);
        space.removeTickListener(this);
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule((Savable)this);
        oc.write(this.ragdollMass, "ragdollMass", 1.0f);
        oc.write((Savable)this.centerLocation, "centerLocation", null);
        oc.write((Savable)this.centerVelocity, "centerVelocity", null);
    }

    @Override
    public void collision(PhysicsCollisionEvent event) {
        DacLinks control;
        if (event.getNodeA() == null && event.getNodeB() == null) {
            return;
        }
        boolean isThisControlInvolved = false;
        PhysicsLink physicsLink = null;
        PhysicsCollisionObject otherPco = null;
        PhysicsCollisionObject pcoA = event.getObjectA();
        PhysicsCollisionObject pcoB = event.getObjectB();
        Object userA = pcoA.getUserObject();
        Object userB = pcoB.getUserObject();
        if (userA instanceof PhysicsLink) {
            physicsLink = (PhysicsLink)userA;
            control = physicsLink.getControl();
            if (control == this) {
                isThisControlInvolved = true;
            }
            otherPco = pcoB;
        }
        if (userB instanceof PhysicsLink) {
            physicsLink = (PhysicsLink)userB;
            control = physicsLink.getControl();
            if (control == this) {
                isThisControlInvolved = true;
            }
            otherPco = pcoA;
        }
        if (!isThisControlInvolved) {
            return;
        }
        float impulseThreshold = this.eventDispatchImpulseThreshold();
        if (event.getAppliedImpulse() < impulseThreshold) {
            return;
        }
        for (RagdollCollisionListener listener : this.collisionListeners) {
            listener.collide(physicsLink, otherPco, event);
        }
    }

    private void blendDescendants(PhysicsLink rootLink, KinematicSubmode submode, float blendInterval) {
        PhysicsLink[] children;
        assert (rootLink != null);
        assert (submode != null);
        assert (blendInterval >= 0.0f) : blendInterval;
        for (PhysicsLink child : children = rootLink.listChildren()) {
            if (child instanceof BoneLink) {
                BoneLink boneLink = (BoneLink)child;
                boneLink.blendToKinematicMode(submode, blendInterval);
            }
            this.blendDescendants(child, submode, blendInterval);
        }
    }

    private void blendSubtree(PhysicsLink rootLink, KinematicSubmode submode, float blendInterval) {
        assert (rootLink != null);
        assert (submode != null);
        assert (blendInterval >= 0.0f) : blendInterval;
        this.blendDescendants(rootLink, submode, blendInterval);
        if (rootLink == this.getTorsoLink()) {
            this.getTorsoLink().blendToKinematicMode(submode, blendInterval, null);
        } else if (rootLink instanceof BoneLink) {
            BoneLink boneLink = (BoneLink)rootLink;
            boneLink.blendToKinematicMode(submode, blendInterval);
        }
    }

    private void recalculateCenter() {
        double massSum = 0.0;
        Vector3f locationSum = new Vector3f();
        Vector3f velocitySum = new Vector3f();
        Vector3f tmpVector = new Vector3f();
        List<PhysicsLink> links = this.listLinks(PhysicsLink.class);
        for (PhysicsLink link : links) {
            PhysicsRigidBody rigidBody = link.getRigidBody();
            float mass = rigidBody.getMass();
            massSum += (double)mass;
            rigidBody.getPhysicsLocation(tmpVector);
            tmpVector.multLocal(mass);
            locationSum.addLocal(tmpVector);
            link.velocity(tmpVector);
            tmpVector.multLocal(mass);
            velocitySum.addLocal(tmpVector);
        }
        float invMass = (float)(1.0 / massSum);
        locationSum.mult(invMass, this.centerLocation);
        velocitySum.mult(invMass, this.centerVelocity);
        this.ragdollMass = (float)massSum;
    }
}

