/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.animation;

import com.jme3.anim.Armature;
import com.jme3.anim.Joint;
import com.jme3.anim.SkinningControl;
import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.PhysicsTickListener;
import com.jme3.bullet.animation.BoneLink;
import com.jme3.bullet.animation.DacConfiguration;
import com.jme3.bullet.animation.PhysicsLink;
import com.jme3.bullet.animation.RagUtils;
import com.jme3.bullet.animation.RangeOfMotion;
import com.jme3.bullet.animation.TorsoLink;
import com.jme3.bullet.animation.VectorSet;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.collision.shapes.HullCollisionShape;
import com.jme3.bullet.joints.PhysicsJoint;
import com.jme3.bullet.joints.SixDofJoint;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.util.clone.Cloner;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DacLinks
extends DacConfiguration
implements PhysicsTickListener {
    public static final Logger logger3 = Logger.getLogger(DacLinks.class.getName());
    private static final Quaternion rotateIdentity = new Quaternion();
    private static final Transform transformIdentity = new Transform();
    private boolean isReady = false;
    private List<BoneLink> boneLinkList = null;
    private Map<String, BoneLink> boneLinks = new HashMap<String, BoneLink>(32);
    private Armature skeleton = null;
    private Spatial transformer = null;
    private TorsoLink torsoLink = null;

    DacLinks() {
    }

    public Joint findBone(String boneName) {
        this.verifyAddedToSpatial("access a bone");
        Joint result = this.skeleton.getJoint(boneName);
        return result;
    }

    public BoneLink findBoneLink(String boneName) {
        BoneLink boneLink = this.boneLinks.get(boneName);
        return boneLink;
    }

    public PhysicsLink findLink(String linkName) {
        PhysicsLink link;
        if (linkName.startsWith("Bone:")) {
            String boneName = linkName.substring(5);
            link = this.findBoneLink(boneName);
        } else {
            assert (linkName.equals("Torso:"));
            link = this.torsoLink;
        }
        return link;
    }

    public Armature getSkeleton() {
        return this.skeleton;
    }

    public TorsoLink getTorsoLink() {
        return this.torsoLink;
    }

    Spatial getTransformer() {
        return this.transformer;
    }

    public boolean isReady() {
        return this.isReady;
    }

    public <T extends PhysicsLink> List<T> listLinks(Class<T> linkType) {
        int numLinks = this.countLinks();
        ArrayList<PhysicsLink> result = new ArrayList<PhysicsLink>(numLinks);
        if (this.torsoLink != null && linkType.isAssignableFrom(this.torsoLink.getClass())) {
            result.add(this.torsoLink);
        }
        for (BoneLink link : this.boneLinkList) {
            if (!linkType.isAssignableFrom(link.getClass())) continue;
            result.add(link);
        }
        return result;
    }

    Joint[] listManagedBones(String managerName) {
        ArrayList<Joint> list = new ArrayList<Joint>(8);
        if ("".equals(managerName)) {
            Joint[] roots;
            for (Joint rootBone : roots = this.skeleton.getRoots()) {
                list.add(rootBone);
                this.addUnlinkedDescendants(rootBone, list);
            }
        } else {
            BoneLink manager = this.findBoneLink(managerName);
            if (manager == null) {
                String msg = "No link named " + managerName;
                throw new IllegalArgumentException(msg);
            }
            Joint managerBone = manager.getBone();
            list.add(managerBone);
            this.addUnlinkedDescendants(managerBone, list);
        }
        int numManagedBones = list.size();
        Joint[] array = new Joint[numManagedBones];
        list.toArray(array);
        return array;
    }

    public PhysicsRigidBody[] listRigidBodies() {
        this.verifyAddedToSpatial("enumerate rigid bodies");
        int numLinks = this.countLinks();
        PhysicsRigidBody[] result = new PhysicsRigidBody[numLinks];
        int linkIndex = 0;
        if (this.torsoLink != null) {
            result[0] = this.torsoLink.getRigidBody();
            ++linkIndex;
        }
        for (BoneLink boneLink : this.boneLinkList) {
            result[linkIndex] = boneLink.getRigidBody();
            ++linkIndex;
        }
        assert (linkIndex == numLinks);
        return result;
    }

    Transform meshTransform(Transform storeResult) {
        Transform result = this.transformer.getWorldTransform().clone();
        return result;
    }

    Transform physicsTransform(Joint bone, Vector3f localOffset, Transform storeResult) {
        Transform result = storeResult == null ? new Transform() : storeResult;
        result.setTranslation(localOffset);
        result.setRotation(rotateIdentity);
        result.setScale(1.0f);
        Transform localToMesh = bone.getModelTransform();
        result.combineWithParent(localToMesh);
        Transform meshToWorld = this.meshTransform(null);
        result.combineWithParent(meshToWorld);
        return result;
    }

    public void rebuild() {
        this.verifyAddedToSpatial("rebuild the ragdoll");
        HashMap<String, BoneLink> saveBones = new HashMap<String, BoneLink>(this.boneLinks);
        TorsoLink saveTorso = this.torsoLink;
        Spatial controlledSpatial = this.getSpatial();
        this.removeSpatialData(controlledSpatial);
        this.createSpatialData(controlledSpatial);
        for (Map.Entry<String, BoneLink> entry : this.boneLinks.entrySet()) {
            String name = entry.getKey();
            BoneLink newLink = entry.getValue();
            BoneLink oldLink = (BoneLink)saveBones.get(name);
            newLink.postRebuild(oldLink);
        }
        if (this.torsoLink != null) {
            this.torsoLink.postRebuild(saveTorso);
        }
    }

    public void setMass(PhysicsLink link, float mass) {
        if (link instanceof BoneLink) {
            String boneName = link.boneName();
            this.setMass(boneName, mass);
        } else {
            assert (link instanceof TorsoLink);
            this.setMass("", mass);
        }
    }

    public void verifyReadyForDynamicMode(String desiredAction) {
        assert (desiredAction != null);
        this.verifyAddedToSpatial(desiredAction);
        if (!this.isReady) {
            String message = "Cannot " + desiredAction + " until the physics has been stepped.";
            throw new IllegalStateException(message);
        }
    }

    protected List<BoneLink> getBoneLinks() {
        assert (this.boneLinkList != null);
        return this.boneLinkList;
    }

    protected void verifyAddedToSpatial(String desiredAction) {
        assert (desiredAction != null);
        Spatial controlledSpatial = this.getSpatial();
        if (controlledSpatial == null) {
            String message = "Cannot " + desiredAction + " unless the Control is added to a Spatial.";
            throw new IllegalStateException(message);
        }
    }

    @Override
    protected void addPhysics(PhysicsSpace space) {
        PhysicsRigidBody rigidBody;
        Vector3f gravity = this.gravity(null);
        if (this.torsoLink != null) {
            rigidBody = this.torsoLink.getRigidBody();
            space.add(rigidBody);
            rigidBody.setGravity(gravity);
        }
        for (BoneLink boneLink : this.boneLinkList) {
            rigidBody = boneLink.getRigidBody();
            space.add(rigidBody);
            rigidBody.setGravity(gravity);
            PhysicsJoint joint = boneLink.getJoint();
            space.add(joint);
        }
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        super.cloneFields(cloner, original);
        DacLinks originalDac = (DacLinks)original;
        this.boneLinkList = (List)cloner.clone(this.boneLinkList);
        this.boneLinks = new HashMap<String, BoneLink>(32);
        for (Map.Entry<String, BoneLink> entry : originalDac.boneLinks.entrySet()) {
            String boneName = entry.getKey();
            BoneLink link = entry.getValue();
            BoneLink copyLink = (BoneLink)cloner.clone((Object)link);
            this.boneLinks.put(boneName, copyLink);
        }
        this.skeleton = (Armature)cloner.clone((Object)this.skeleton);
        this.transformer = (Spatial)cloner.clone((Object)this.transformer);
        this.torsoLink = (TorsoLink)cloner.clone((Object)this.torsoLink);
    }

    @Override
    protected void createSpatialData(Spatial spatial) {
        String[] linkedBoneNames;
        RagUtils.validate(spatial);
        SkinningControl skeletonControl = (SkinningControl)spatial.getControl(SkinningControl.class);
        if (skeletonControl == null) {
            throw new IllegalArgumentException("The controlled spatial must have a SkinningControl. Make sure the control is there and not on a subnode.");
        }
        this.sortControls(skeletonControl);
        skeletonControl.setHardwareSkinningPreferred(false);
        this.skeleton = skeletonControl.getArmature();
        this.validateSkeleton();
        String[] tempManagerMap = this.managerMap(this.skeleton);
        int numBones = this.skeleton.getJointCount();
        Transform[] savedTransforms = new Transform[numBones];
        for (int boneIndex = 0; boneIndex < numBones; ++boneIndex) {
            Joint bone = this.skeleton.getJoint(boneIndex);
            savedTransforms[boneIndex] = bone.getLocalTransform().clone();
            bone.applyBindPose();
        }
        this.skeleton.update();
        List<Mesh> targetList = RagUtils.listAnimatedMeshes(spatial, null);
        Mesh[] targets = new Mesh[targetList.size()];
        targetList.toArray(targets);
        this.transformer = RagUtils.findAnimatedGeometry(spatial);
        if (this.transformer == null) {
            this.transformer = spatial;
        }
        Map<String, VectorSet> coordsMap = RagUtils.coordsMap(targets, tempManagerMap);
        VectorSet vertexLocations = coordsMap.get("");
        this.createTorsoLink(vertexLocations, targets);
        for (String boneName : linkedBoneNames = this.listLinkedBoneNames()) {
            vertexLocations = coordsMap.get(boneName);
            this.createBoneLink(boneName, vertexLocations);
        }
        int numLinkedBones = this.countLinkedBones();
        assert (this.boneLinks.size() == numLinkedBones);
        this.boneLinkList = new ArrayList<BoneLink>(numLinkedBones);
        this.addJoints(this.torsoLink);
        assert (this.boneLinkList.size() == numLinkedBones) : this.boneLinkList.size();
        for (int boneIndex = 0; boneIndex < numBones; ++boneIndex) {
            Joint bone = this.skeleton.getJoint(boneIndex);
            bone.setLocalTransform(savedTransforms[boneIndex]);
        }
        this.skeleton.update();
        if (this.added) {
            this.addPhysics(this.space);
        }
        logger3.log(Level.FINE, "Created ragdoll for skeleton.");
    }

    @Override
    public DacLinks jmeClone() {
        try {
            DacLinks clone = (DacLinks)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public float mass(String boneName) {
        float mass;
        if (this.getSpatial() == null) {
            mass = super.mass(boneName);
        } else if ("".equals(boneName)) {
            PhysicsRigidBody rigidBody = this.torsoLink.getRigidBody();
            mass = rigidBody.getMass();
        } else if (this.boneLinks.containsKey(boneName)) {
            BoneLink link = this.boneLinks.get(boneName);
            PhysicsRigidBody rigidBody = link.getRigidBody();
            mass = rigidBody.getMass();
        } else {
            String msg = "No bone/torso named " + boneName;
            throw new IllegalArgumentException(msg);
        }
        return mass;
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule((Savable)this);
        this.boneLinkList = ic.readSavableArrayList("boneLinkList", null);
        for (BoneLink link : this.boneLinkList) {
            String name = link.boneName();
            this.boneLinks.put(name, link);
        }
        this.skeleton = (Armature)ic.readSavable("skeleton", null);
        this.transformer = (Spatial)ic.readSavable("transformer", null);
        this.torsoLink = (TorsoLink)ic.readSavable("torsoLink", null);
    }

    @Override
    protected void removePhysics(PhysicsSpace space) {
        PhysicsRigidBody rigidBody;
        assert (this.added);
        if (this.torsoLink != null) {
            rigidBody = this.torsoLink.getRigidBody();
            space.remove(rigidBody);
        }
        for (BoneLink boneLink : this.boneLinks.values()) {
            rigidBody = boneLink.getRigidBody();
            space.remove(rigidBody);
            PhysicsJoint joint = boneLink.getJoint();
            space.remove(joint);
        }
    }

    @Override
    protected void removeSpatialData(Spatial spat) {
        if (this.added) {
            this.removePhysics(this.space);
        }
        this.skeleton = null;
        this.boneLinks.clear();
        this.boneLinkList = null;
        this.torsoLink = null;
        this.transformer = null;
    }

    @Override
    public void setDamping(float dampingRatio) {
        super.setDamping(dampingRatio);
        if (this.getSpatial() != null) {
            PhysicsRigidBody[] bodies;
            for (PhysicsRigidBody rigidBody : bodies = this.listRigidBodies()) {
                rigidBody.setDamping(dampingRatio, dampingRatio);
            }
        }
    }

    @Override
    public void setGravity(Vector3f gravity) {
        super.setGravity(gravity);
        if (this.getSpatial() != null) {
            PhysicsRigidBody[] bodies;
            for (PhysicsRigidBody rigidBody : bodies = this.listRigidBodies()) {
                rigidBody.setGravity(gravity);
            }
        }
    }

    @Override
    public void setJointLimits(String boneName, RangeOfMotion rom) {
        if (!this.hasBoneLink(boneName)) {
            String msg = "No linked bone named " + boneName;
            throw new IllegalArgumentException(msg);
        }
        super.setJointLimits(boneName, rom);
        if (this.getSpatial() != null) {
            BoneLink boneLink = this.findBoneLink(boneName);
            SixDofJoint joint = (SixDofJoint)boneLink.getJoint();
            rom.setupJoint(joint);
        }
    }

    @Override
    public void setMass(String boneName, float mass) {
        super.setMass(boneName, mass);
        if (this.getSpatial() != null) {
            PhysicsRigidBody rigidBody;
            if ("".equals(boneName)) {
                rigidBody = this.torsoLink.getRigidBody();
            } else {
                BoneLink link = this.findBoneLink(boneName);
                rigidBody = link.getRigidBody();
            }
            rigidBody.setMass(mass);
        }
    }

    @Override
    protected void setPhysicsLocation(Vector3f vec) {
        this.torsoLink.getRigidBody().setPhysicsLocation(vec);
    }

    @Override
    protected void setPhysicsRotation(Quaternion quat) {
        this.torsoLink.getRigidBody().setPhysicsRotation(quat);
    }

    @Override
    public void update(float tpf) {
        this.verifyAddedToSpatial("update the control");
        if (!this.isEnabled()) {
            return;
        }
        if (this.torsoLink != null) {
            this.torsoLink.update(tpf);
        }
        for (BoneLink boneLink : this.boneLinkList) {
            boneLink.update(tpf);
        }
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule((Savable)this);
        int count = this.countLinkedBones();
        Savable[] savableArray = new Savable[count];
        this.boneLinkList.toArray(savableArray);
        oc.write(savableArray, "boneLinkList", null);
        oc.write((Savable)this.skeleton, "skeleton", null);
        oc.write((Savable)this.transformer, "transformer", null);
        oc.write((Savable)this.torsoLink, "torsoLink", null);
    }

    @Override
    public void physicsTick(PhysicsSpace space, float timeStep) {
        assert (space == this.getPhysicsSpace());
        this.torsoLink.postTick();
        for (BoneLink boneLink : this.boneLinkList) {
            boneLink.postTick();
        }
        this.isReady = true;
    }

    @Override
    public void prePhysicsTick(PhysicsSpace space, float timeStep) {
        assert (space == this.getPhysicsSpace());
        this.torsoLink.preTick(timeStep);
        for (BoneLink boneLink : this.boneLinkList) {
            boneLink.preTick(timeStep);
        }
    }

    private void addJoints(PhysicsLink parentLink) {
        List<String> childNames = this.childNames(parentLink);
        for (String childName : childNames) {
            BoneLink childLink = this.findBoneLink(childName);
            childLink.addJoint(parentLink);
            this.boneLinkList.add(childLink);
            this.addJoints(childLink);
        }
    }

    private List<String> childNames(PhysicsLink link) {
        assert (link != null);
        String linkName = link == this.torsoLink ? "" : link.boneName();
        ArrayList<String> result = new ArrayList<String>(8);
        for (String childName : this.listLinkedBoneNames()) {
            Joint bone = this.findBone(childName);
            Joint parent = bone.getParent();
            if (parent == null || !this.findManager(parent).equals(linkName)) continue;
            result.add(childName);
        }
        return result;
    }

    private void createBoneLink(String boneName, VectorSet vertexLocations) {
        Joint bone = this.findBone(boneName);
        Transform boneToMesh = bone.getModelTransform();
        Transform meshToBone = boneToMesh.invert();
        if (vertexLocations == null || vertexLocations.numVectors() == 0) {
            throw new IllegalStateException("no vertex for " + boneName);
        }
        Vector3f center = vertexLocations.mean(null);
        center.subtractLocal(bone.getModelTransform().getTranslation());
        CollisionShape shape = this.createShape(meshToBone, center, vertexLocations);
        meshToBone.getTranslation().zero();
        float mass = super.mass(boneName);
        Vector3f offset = meshToBone.transformVector(center, null);
        BoneLink link = new BoneLink(this, bone, shape, mass, offset);
        this.boneLinks.put(boneName, link);
    }

    private CollisionShape createShape(Transform vertexToShape, Vector3f center, VectorSet vertexLocations) {
        int numVectors = vertexLocations.numVectors();
        assert (numVectors > 0) : numVectors;
        Vector3f tempLocation = new Vector3f();
        int numPoints = vertexLocations.numVectors();
        float[] points = new float[3 * numPoints];
        FloatBuffer buffer = vertexLocations.toBuffer();
        buffer.rewind();
        int floatIndex = 0;
        while (buffer.hasRemaining()) {
            tempLocation.x = buffer.get();
            tempLocation.y = buffer.get();
            tempLocation.z = buffer.get();
            tempLocation.subtractLocal(center);
            vertexToShape.transformVector(tempLocation, tempLocation);
            points[floatIndex] = tempLocation.x;
            points[floatIndex + 1] = tempLocation.y;
            points[floatIndex + 2] = tempLocation.z;
            floatIndex += 3;
        }
        HullCollisionShape result = new HullCollisionShape(points);
        return result;
    }

    private void createTorsoLink(VectorSet vertexLocations, Mesh[] meshes) {
        Transform meshToModel;
        if (vertexLocations == null || vertexLocations.numVectors() == 0) {
            throw new IllegalArgumentException("No mesh vertices for the torso. Make sure the root bone is not linked.");
        }
        Joint bone = RagUtils.findMainBone(this.skeleton, meshes);
        assert (bone.getParent() == null);
        Transform boneToMesh = bone.getModelTransform();
        Transform meshToBone = boneToMesh.invert();
        Vector3f center = vertexLocations.mean(null);
        center.subtractLocal(boneToMesh.getTranslation());
        CollisionShape shape = this.createShape(meshToBone, center, vertexLocations);
        meshToBone.getTranslation().zero();
        Vector3f offset = meshToBone.transformVector(center, null);
        Spatial cgm = this.getSpatial();
        if (cgm instanceof Node) {
            Transform modelToMesh = RagUtils.relativeTransform(this.transformer, (Node)cgm, null);
            meshToModel = modelToMesh.invert();
        } else {
            meshToModel = transformIdentity;
        }
        float mass = super.mass("");
        this.torsoLink = new TorsoLink(this, bone, shape, mass, meshToModel, offset);
    }

    private void sortControls(SkinningControl skinningControl) {
        assert (skinningControl != null);
        int dacIndex = RagUtils.findIndex(this.spatial, this);
        assert (dacIndex != -1);
        int scIndex = RagUtils.findIndex(this.spatial, (Control)skinningControl);
        assert (scIndex != -1);
        assert (dacIndex != scIndex);
        if (dacIndex > scIndex) {
            this.spatial.removeControl((Control)skinningControl);
            this.spatial.addControl((Control)skinningControl);
            dacIndex = RagUtils.findIndex(this.spatial, this);
            assert (dacIndex != -1);
            scIndex = RagUtils.findIndex(this.spatial, (Control)skinningControl);
            assert (scIndex != -1);
            assert (dacIndex < scIndex);
        }
    }

    private void validateSkeleton() {
        RagUtils.validate(this.skeleton);
        for (String boneName : this.listLinkedBoneNames()) {
            Joint bone = this.findBone(boneName);
            if (bone == null) {
                String msg = String.format("Linked bone %s not found in skeleton.", boneName);
                throw new IllegalArgumentException(msg);
            }
            if (bone.getParent() != null) continue;
            logger3.log(Level.WARNING, "Linked bone {0} is a root bone.", boneName);
        }
    }
}

