/*
 * Decompiled with CFR 0.152.
 */
package de.jarnbjo.vorbis;

import de.jarnbjo.util.io.BitInputStream;
import de.jarnbjo.vorbis.CodeBook;
import de.jarnbjo.vorbis.Floor;
import de.jarnbjo.vorbis.Mapping;
import de.jarnbjo.vorbis.Mode;
import de.jarnbjo.vorbis.Residue;
import de.jarnbjo.vorbis.VorbisFormatException;
import de.jarnbjo.vorbis.VorbisStream;
import java.io.IOException;

class SetupHeader {
    private static final long HEADER = 126896460427126L;
    private final CodeBook[] codeBooks;
    private final Floor[] floors;
    private final Residue[] residues;
    private final Mapping[] mappings;
    private final Mode[] modes;

    SetupHeader(VorbisStream vorbis, BitInputStream source) throws IOException {
        if (source.getLong(48) != 126896460427126L) {
            throw new VorbisFormatException("The setup header has an illegal leading.");
        }
        int codeBookCount = source.getInt(8) + 1;
        this.codeBooks = new CodeBook[codeBookCount];
        for (int i = 0; i < this.codeBooks.length; ++i) {
            this.codeBooks[i] = new CodeBook(source);
        }
        int timeCount = source.getInt(6) + 1;
        for (int i = 0; i < timeCount; ++i) {
            if (source.getInt(16) == 0) continue;
            throw new VorbisFormatException("Time domain transformation != 0");
        }
        int floorCount = source.getInt(6) + 1;
        this.floors = new Floor[floorCount];
        for (int i = 0; i < floorCount; ++i) {
            this.floors[i] = Floor.createInstance(source, this);
        }
        int residueCount = source.getInt(6) + 1;
        this.residues = new Residue[residueCount];
        for (int i = 0; i < residueCount; ++i) {
            this.residues[i] = Residue.createInstance(source, this);
        }
        int mappingCount = source.getInt(6) + 1;
        this.mappings = new Mapping[mappingCount];
        for (int i = 0; i < mappingCount; ++i) {
            this.mappings[i] = Mapping.createInstance(vorbis, source, this);
        }
        int modeCount = source.getInt(6) + 1;
        this.modes = new Mode[modeCount];
        for (int i = 0; i < modeCount; ++i) {
            this.modes[i] = new Mode(source, this);
        }
        if (!source.getBit()) {
            throw new VorbisFormatException("The setup header framing bit is incorrect.");
        }
    }

    public CodeBook[] getCodeBooks() {
        return this.codeBooks;
    }

    public Floor[] getFloors() {
        return this.floors;
    }

    public Residue[] getResidues() {
        return this.residues;
    }

    public Mapping[] getMappings() {
        return this.mappings;
    }

    public Mode[] getModes() {
        return this.modes;
    }
}

