/*
 * Decompiled with CFR 0.152.
 */
package de.jarnbjo.vorbis;

import de.jarnbjo.util.io.BitInputStream;
import de.jarnbjo.vorbis.CodeBook;
import de.jarnbjo.vorbis.Mode;
import de.jarnbjo.vorbis.Residue0;
import de.jarnbjo.vorbis.Residue2;
import de.jarnbjo.vorbis.SetupHeader;
import de.jarnbjo.vorbis.Util;
import de.jarnbjo.vorbis.VorbisFormatException;
import de.jarnbjo.vorbis.VorbisStream;
import java.io.IOException;
import java.util.HashMap;

abstract class Residue {
    protected int begin;
    protected int end;
    protected int partitionSize;
    protected int classifications;
    protected int classBook;
    protected int[] cascade;
    protected int[][] books;
    protected HashMap looks = new HashMap();

    protected Residue() {
    }

    protected Residue(BitInputStream source, SetupHeader header) throws IOException {
        int i;
        this.begin = source.getInt(24);
        this.end = source.getInt(24);
        this.partitionSize = source.getInt(24) + 1;
        this.classifications = source.getInt(6) + 1;
        this.classBook = source.getInt(8);
        this.cascade = new int[this.classifications];
        int acc = 0;
        for (i = 0; i < this.classifications; ++i) {
            int highBits = 0;
            int lowBits = 0;
            lowBits = source.getInt(3);
            if (source.getBit()) {
                highBits = source.getInt(5);
            }
            this.cascade[i] = highBits << 3 | lowBits;
            acc += Util.icount(this.cascade[i]);
        }
        this.books = new int[this.classifications][8];
        for (i = 0; i < this.classifications; ++i) {
            for (int j = 0; j < 8; ++j) {
                if ((this.cascade[i] & 1 << j) == 0) continue;
                this.books[i][j] = source.getInt(8);
                if (this.books[i][j] <= header.getCodeBooks().length) continue;
                throw new VorbisFormatException("Reference to invalid codebook entry in residue header.");
            }
        }
    }

    protected static Residue createInstance(BitInputStream source, SetupHeader header) throws IOException {
        int type = source.getInt(16);
        switch (type) {
            case 0: {
                return new Residue0(source, header);
            }
            case 1: {
                return new Residue2(source, header);
            }
            case 2: {
                return new Residue2(source, header);
            }
        }
        throw new VorbisFormatException("Residue type " + type + " is not supported.");
    }

    protected abstract int getType();

    protected abstract void decodeResidue(VorbisStream var1, BitInputStream var2, Mode var3, int var4, boolean[] var5, float[][] var6) throws IOException;

    protected int getBegin() {
        return this.begin;
    }

    protected int getEnd() {
        return this.end;
    }

    protected int getPartitionSize() {
        return this.partitionSize;
    }

    protected int getClassifications() {
        return this.classifications;
    }

    protected int getClassBook() {
        return this.classBook;
    }

    protected int[] getCascade() {
        return this.cascade;
    }

    protected int[][] getBooks() {
        return this.books;
    }

    protected final void fill(Residue clone) {
        clone.begin = this.begin;
        clone.books = this.books;
        clone.cascade = this.cascade;
        clone.classBook = this.classBook;
        clone.classifications = this.classifications;
        clone.end = this.end;
        clone.partitionSize = this.partitionSize;
    }

    protected Look getLook(VorbisStream source, Mode key) {
        Look look = (Look)this.looks.get(key);
        if (look == null) {
            look = new Look(source, key);
            this.looks.put(key, look);
        }
        return look;
    }

    class Look {
        int map;
        int parts;
        int stages;
        CodeBook[] fullbooks;
        CodeBook phrasebook;
        int[][] partbooks;
        int partvals;
        int[][] decodemap;
        int postbits;
        int phrasebits;
        int frames;

        protected Look(VorbisStream source, Mode mode) {
            int j;
            int dim = 0;
            boolean acc = false;
            int maxstage = 0;
            this.map = mode.getMapping();
            this.parts = Residue.this.getClassifications();
            this.fullbooks = source.getSetupHeader().getCodeBooks();
            this.phrasebook = this.fullbooks[Residue.this.getClassBook()];
            dim = this.phrasebook.getDimensions();
            this.partbooks = new int[this.parts][];
            for (j = 0; j < this.parts; ++j) {
                int stages = Util.ilog(Residue.this.getCascade()[j]);
                if (stages == 0) continue;
                if (stages > maxstage) {
                    maxstage = stages;
                }
                this.partbooks[j] = new int[stages];
                for (int k = 0; k < stages; ++k) {
                    if ((Residue.this.getCascade()[j] & 1 << k) == 0) continue;
                    this.partbooks[j][k] = Residue.this.getBooks()[j][k];
                }
            }
            this.partvals = (int)Math.rint(Math.pow(this.parts, dim));
            this.stages = maxstage;
            this.decodemap = new int[this.partvals][];
            for (j = 0; j < this.partvals; ++j) {
                int val = j;
                int mult = this.partvals / this.parts;
                this.decodemap[j] = new int[dim];
                for (int k = 0; k < dim; ++k) {
                    int deco = val / mult;
                    val -= deco * mult;
                    mult /= this.parts;
                    this.decodemap[j][k] = deco;
                }
            }
        }

        protected int[][] getDecodeMap() {
            return this.decodemap;
        }

        protected int getFrames() {
            return this.frames;
        }

        protected int getMap() {
            return this.map;
        }

        protected int[][] getPartBooks() {
            return this.partbooks;
        }

        protected int getParts() {
            return this.parts;
        }

        protected int getPartVals() {
            return this.partvals;
        }

        protected int getPhraseBits() {
            return this.phrasebits;
        }

        protected CodeBook getPhraseBook() {
            return this.phrasebook;
        }

        protected int getPostBits() {
            return this.postbits;
        }

        protected int getStages() {
            return this.stages;
        }
    }
}

