/*
 * Decompiled with CFR 0.152.
 */
package de.jarnbjo.vorbis;

import de.jarnbjo.util.io.BitInputStream;
import de.jarnbjo.util.io.ByteArrayBitInputStream;
import de.jarnbjo.vorbis.VorbisFormatException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;

public class CommentHeader {
    private static final String defaultCharsetName;
    public static final String TITLE = "TITLE";
    public static final String ARTIST = "ARTIST";
    public static final String ALBUM = "ALBUM";
    public static final String TRACKNUMBER = "TRACKNUMBER";
    public static final String VERSION = "VERSION";
    public static final String PERFORMER = "PERFORMER";
    public static final String COPYRIGHT = "COPYRIGHT";
    public static final String LICENSE = "LICENSE";
    public static final String ORGANIZATION = "ORGANIZATION";
    public static final String DESCRIPTION = "DESCRIPTION";
    public static final String GENRE = "GENRE";
    public static final String DATE = "DATE";
    public static final String LOCATION = "LOCATION";
    public static final String CONTACT = "CONTACT";
    public static final String ISRC = "ISRC";
    public static final String METADATA_BLOCK_PICTURE = "METADATA_BLOCK_PICTURE";
    private final String vendor;
    private final HashMap comments = new HashMap();
    private boolean framingBit;
    private static final long HEADER = 126896460427126L;

    public CommentHeader(BitInputStream source) throws IOException {
        if (source.getLong(48) != 126896460427126L) {
            throw new VorbisFormatException("The identification header has an illegal leading.");
        }
        this.vendor = CommentHeader.getString(source);
        int ucLength = source.getInt(32);
        for (int i = 0; i < ucLength; ++i) {
            String comment = CommentHeader.getString(source);
            int ix = comment.indexOf(61);
            String key = comment.substring(0, ix);
            String value = comment.substring(ix + 1);
            this.addComment(key, value);
        }
        this.framingBit = source.getInt(8) != 0;
    }

    public static String byteBufferToString(byte[] bytes, int offset, int length) throws UnsupportedEncodingException {
        return CommentHeader.byteBufferToString(bytes, offset, length, defaultCharsetName);
    }

    public static String byteBufferToString(byte[] bytes, int offset, int length, String charsetName) throws UnsupportedEncodingException {
        if (length < 1) {
            return "";
        }
        return new String(bytes, offset, length, charsetName);
    }

    private void addComment(String key, String value) {
        ArrayList<String> al = (ArrayList<String>)this.comments.get(key);
        if (al == null) {
            al = new ArrayList<String>();
            this.comments.put(key, al);
        }
        al.add(value);
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getComment(String key) {
        ArrayList al = (ArrayList)this.comments.get(key);
        return al == null ? null : (String)al.get(0);
    }

    public String[] getComments(String key) {
        ArrayList al = (ArrayList)this.comments.get(key);
        return al == null ? new String[]{} : al.toArray(new String[al.size()]);
    }

    public String getTitle() {
        return this.getComment(TITLE);
    }

    public String[] getTitles() {
        return this.getComments(TITLE);
    }

    public String getVersion() {
        return this.getComment(VERSION);
    }

    public String[] getVersions() {
        return this.getComments(VERSION);
    }

    public String getAlbum() {
        return this.getComment(ALBUM);
    }

    public String[] getAlbums() {
        return this.getComments(ALBUM);
    }

    public String getTrackNumber() {
        return this.getComment(TRACKNUMBER);
    }

    public String[] getTrackNumbers() {
        return this.getComments(TRACKNUMBER);
    }

    public String getArtist() {
        return this.getComment(ARTIST);
    }

    public String[] getArtists() {
        return this.getComments(ARTIST);
    }

    public String getPerformer() {
        return this.getComment(PERFORMER);
    }

    public String[] getPerformers() {
        return this.getComments(PERFORMER);
    }

    public String getCopyright() {
        return this.getComment(COPYRIGHT);
    }

    public String[] getCopyrights() {
        return this.getComments(COPYRIGHT);
    }

    public String getLicense() {
        return this.getComment(LICENSE);
    }

    public String[] getLicenses() {
        return this.getComments(LICENSE);
    }

    public String getOrganization() {
        return this.getComment(ORGANIZATION);
    }

    public String[] getOrganizations() {
        return this.getComments(ORGANIZATION);
    }

    public String getDescription() {
        return this.getComment(DESCRIPTION);
    }

    public String[] getDescriptions() {
        return this.getComments(DESCRIPTION);
    }

    public String getGenre() {
        return this.getComment(GENRE);
    }

    public String[] getGenres() {
        return this.getComments(GENRE);
    }

    public String getDate() {
        return this.getComment(DATE);
    }

    public String[] getDates() {
        return this.getComments(DATE);
    }

    public String getLocation() {
        return this.getComment(LOCATION);
    }

    public String[] getLocations() {
        return this.getComments(LOCATION);
    }

    public String getContact() {
        return this.getComment(CONTACT);
    }

    public String[] getContacts() {
        return this.getComments(CONTACT);
    }

    public String getIsrc() {
        return this.getComment(ISRC);
    }

    public String[] getIsrcs() {
        return this.getComments(ISRC);
    }

    private static String getString(BitInputStream source) throws IOException {
        int length = source.getInt(32);
        byte[] strArray = new byte[length];
        for (int i = 0; i < length; ++i) {
            strArray[i] = (byte)source.getInt(8);
        }
        return new String(strArray, "UTF-8");
    }

    public byte[] getAlbumArt() throws IOException {
        String base64 = this.getComment(METADATA_BLOCK_PICTURE);
        if (base64 == null) {
            return null;
        }
        byte[] bytes = Base64.decode(base64);
        ByteArrayBitInputStream bis = new ByteArrayBitInputStream(bytes);
        bis.setEndian(1);
        int pictype = bis.getInt(32);
        System.err.print("pictype: " + pictype + ", " + Integer.toHexString(pictype) + System.lineSeparator());
        int mimeTypeLength = bis.getInt(32);
        System.err.print("mimetype_len: " + mimeTypeLength + ", " + Integer.toHexString(mimeTypeLength) + System.lineSeparator());
        String mimetype = CommentHeader.byteBufferToString(bytes, bis.position() + 1, mimeTypeLength);
        System.err.print("mimetype: " + mimetype + System.lineSeparator());
        bis.skip(mimetype.length() + 2);
        int descStringByteCount = bis.getInt(32);
        System.err.print("descStringByteCount: " + descStringByteCount + ", " + Integer.toHexString(descStringByteCount) + System.lineSeparator());
        if (descStringByteCount != 0) {
            String descString = CommentHeader.byteBufferToString(bytes, bis.position() + 1, descStringByteCount);
            System.err.print("descString: " + descString + System.lineSeparator());
            bis.skip(descStringByteCount + 2);
        }
        int width = bis.getInt(32);
        System.err.print("width: " + width + ", " + Integer.toHexString(width) + System.lineSeparator());
        int height = bis.getInt(32);
        System.err.print("height: " + height + ", " + Integer.toHexString(height) + System.lineSeparator());
        int bpp = bis.getInt(32);
        System.err.print("bpp: " + bpp + ", " + Integer.toHexString(bpp) + System.lineSeparator());
        int colorCount = bis.getInt(32);
        System.err.print("color_count: " + colorCount + ", " + Integer.toHexString(colorCount) + System.lineSeparator());
        int byteCount = bis.getInt(32);
        System.err.print("byte_count: " + byteCount + ", " + Integer.toHexString(byteCount) + System.lineSeparator());
        byte[] data = new byte[byteCount];
        System.arraycopy(bytes, bis.position() + 1, data, 0, data.length);
        return data;
    }

    static {
        Charset charset = Charset.forName("ISO-8859-1");
        defaultCharsetName = charset.name();
    }

    private static class Base64 {
        private static final char[] ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
        private static int[] toInt = new int[128];

        private Base64() {
        }

        public static byte[] decode(String s) {
            int delta = s.endsWith("==") ? 2 : (s.endsWith("=") ? 1 : 0);
            byte[] buffer = new byte[s.length() * 3 / 4 - delta];
            int mask = 255;
            int index = 0;
            for (int i = 0; i < s.length(); i += 4) {
                int c0 = toInt[s.charAt(i)];
                int c1 = toInt[s.charAt(i + 1)];
                buffer[index++] = (byte)((c0 << 2 | c1 >> 4) & mask);
                if (index >= buffer.length) {
                    return buffer;
                }
                int c2 = toInt[s.charAt(i + 2)];
                buffer[index++] = (byte)((c1 << 4 | c2 >> 2) & mask);
                if (index >= buffer.length) {
                    return buffer;
                }
                int c3 = toInt[s.charAt(i + 3)];
                buffer[index++] = (byte)((c2 << 6 | c3) & mask);
            }
            return buffer;
        }

        static {
            for (int i = 0; i < ALPHABET.length; ++i) {
                Base64.toInt[Base64.ALPHABET[i]] = i;
            }
        }
    }
}

