/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.input;

import com.jme3.cursors.plugins.JmeCursor;
import com.jme3.input.AWTInput;
import com.jme3.input.MouseInput;
import com.jme3.input.event.MouseButtonEvent;
import com.jme3.input.event.MouseMotionEvent;
import com.jme3.system.AWTContext;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class AWTMouseInput
extends AWTInput
implements MouseInput,
MouseListener,
MouseMotionListener,
MouseWheelListener {
    private static final Map<Integer, Integer> MOUSE_BUTTON_TO_JME = new HashMap<Integer, Integer>();
    private static final int WHEEL_SCALE = 10;
    private final Deque<MouseMotionEvent> mouseMotionEvents = new LinkedList<MouseMotionEvent>();
    private final Deque<MouseButtonEvent> mouseButtonEvents = new LinkedList<MouseButtonEvent>();
    private int mouseX;
    private int mouseY;
    private int mouseWheel;

    public AWTMouseInput(AWTContext context) {
        super(context);
    }

    @Override
    public void bind(Component component) {
        super.bind(component);
        component.addMouseListener(this);
        component.addMouseMotionListener(this);
        component.addMouseWheelListener(this);
    }

    @Override
    public void unbind() {
        if (this.component != null) {
            this.component.removeMouseListener(this);
            this.component.removeMouseMotionListener(this);
            this.component.removeMouseWheelListener(this);
        }
        super.unbind();
    }

    @Override
    protected void updateImpl() {
        while (!this.mouseMotionEvents.isEmpty()) {
            this.listener.onMouseMotionEvent(this.mouseMotionEvents.poll());
        }
        while (!this.mouseButtonEvents.isEmpty()) {
            this.listener.onMouseButtonEvent(this.mouseButtonEvents.poll());
        }
    }

    private void onWheelScroll(double xOffset, double yOffset) {
        this.mouseWheel = (int)((double)this.mouseWheel + yOffset);
        final MouseMotionEvent mouseMotionEvent = new MouseMotionEvent(this.mouseX, this.mouseY, 0, 0, this.mouseWheel, (int)Math.round(yOffset));
        mouseMotionEvent.setTime(this.getInputTimeNanos());
        EXECUTOR.addToExecute(new Runnable(){

            @Override
            public void run() {
                AWTMouseInput.this.mouseMotionEvents.add(mouseMotionEvent);
            }
        });
    }

    private void onCursorPos(double xpos, double ypos) {
        int x = (int)Math.round(xpos);
        int y = this.context.getHeight() - (int)Math.round(ypos);
        if (this.mouseX == 0) {
            this.mouseX = x;
        }
        if (this.mouseY == 0) {
            this.mouseY = y;
        }
        int xDelta = x - this.mouseX;
        int yDelta = y - this.mouseY;
        this.mouseX = x;
        this.mouseY = y;
        if (xDelta == 0 && yDelta == 0) {
            return;
        }
        final MouseMotionEvent mouseMotionEvent = new MouseMotionEvent(x, y, xDelta, yDelta, this.mouseWheel, 0);
        mouseMotionEvent.setTime(this.getInputTimeNanos());
        EXECUTOR.addToExecute(new Runnable(){

            @Override
            public void run() {
                AWTMouseInput.this.mouseMotionEvents.add(mouseMotionEvent);
            }
        });
    }

    private void onMouseButton(MouseEvent event, boolean pressed) {
        final MouseButtonEvent mouseButtonEvent = new MouseButtonEvent(this.convertButton(event.getButton()), pressed, this.mouseX, this.mouseY);
        mouseButtonEvent.setTime(this.getInputTimeNanos());
        EXECUTOR.addToExecute(new Runnable(){

            @Override
            public void run() {
                AWTMouseInput.this.mouseButtonEvents.add(mouseButtonEvent);
            }
        });
    }

    private int convertButton(int i) {
        Integer result = MOUSE_BUTTON_TO_JME.get(i);
        return result == null ? 0 : result;
    }

    public void setCursorVisible(boolean visible) {
    }

    public int getButtonCount() {
        return 3;
    }

    public void setNativeCursor(JmeCursor cursor) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.onCursorPos(e.getX(), e.getY());
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.onMouseButton(e, true);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.onMouseButton(e, false);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        this.onWheelScroll(e.getWheelRotation() * 10, e.getWheelRotation() * 10);
    }

    static {
        MOUSE_BUTTON_TO_JME.put(1, 0);
        MOUSE_BUTTON_TO_JME.put(2, 1);
        MOUSE_BUTTON_TO_JME.put(3, 2);
    }
}

