/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.terrain.geomipmap;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.AbstractControl;
import com.jme3.scene.control.Control;
import com.jme3.terrain.Terrain;
import com.jme3.terrain.executor.TerrainExecutorService;
import com.jme3.terrain.geomipmap.TerrainQuad;
import com.jme3.terrain.geomipmap.UpdatedTerrainPatch;
import com.jme3.terrain.geomipmap.lodcalc.DistanceLodCalculator;
import com.jme3.terrain.geomipmap.lodcalc.LodCalculator;
import com.jme3.util.SafeArrayList;
import com.jme3.util.clone.Cloner;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TerrainLodControl
extends AbstractControl {
    protected SafeArrayList<Camera> cameras;
    protected SafeArrayList<Vector3f> cameraLocations;
    protected SafeArrayList<Vector3f> lastCameraLocations;
    protected AtomicBoolean lodCalcRunning;
    protected Vector3f previousCameraLocation = new Vector3f();
    protected Camera camera;
    protected Terrain terrain;
    protected LodCalculator lodCalculator;
    protected Future<HashMap<String, UpdatedTerrainPatch>> indexer;
    private int lodOffCount = 0;
    protected boolean useRenderCamera;
    protected boolean forceUpdate = true;
    protected boolean hasResetLod = false;

    public TerrainLodControl() {
        this.cameras = new SafeArrayList(Camera.class);
        this.cameraLocations = new SafeArrayList(Vector3f.class);
        this.lastCameraLocations = new SafeArrayList(Vector3f.class);
        this.lodCalcRunning = new AtomicBoolean(false);
        this.lodCalculator = this.makeLodCalculator();
    }

    protected DistanceLodCalculator makeLodCalculator() {
        return new DistanceLodCalculator(65, 2.7f);
    }

    public TerrainLodControl(Terrain terrain) {
        this();
        this.terrain = terrain;
    }

    public TerrainLodControl(Camera camera) {
        this();
        this.setCamera(camera);
    }

    public TerrainLodControl(Terrain terrain, Camera camera) {
        this(terrain);
        this.setCamera(camera);
    }

    public TerrainLodControl(Terrain terrain, List<Camera> cameras) {
        this(terrain);
        this.setCameras(cameras);
    }

    public void setUseRenderCamera(boolean useRenderCamera) {
        this.useRenderCamera = useRenderCamera;
    }

    public boolean isUseRenderCamera() {
        return this.useRenderCamera;
    }

    protected void controlRender(RenderManager rm, ViewPort vp) {
        if (!this.isUseRenderCamera()) {
            return;
        }
        if (this.camera == vp.getCamera()) {
            return;
        }
        this.camera = vp.getCamera();
        this.previousCameraLocation.set(this.camera.getLocation());
    }

    protected void controlUpdate(float tpf) {
        if (this.lodCalculator == null) {
            return;
        }
        if (!this.enabled && !this.hasResetLod) {
            this.hasResetLod = true;
            this.lodCalculator.turnOffLod();
        }
        if (this.isUseRenderCamera()) {
            this.updateLOD(this.lodCalculator);
        } else if (!this.cameras.isEmpty()) {
            int i;
            if (this.cameraLocations.size() != this.cameras.size()) {
                this.cameraLocations.clear();
                for (i = 0; i < this.cameras.size(); ++i) {
                    this.cameraLocations.add((Object)new Vector3f());
                }
            }
            for (i = 0; i < this.cameras.size(); ++i) {
                ((Vector3f)this.cameraLocations.get(i)).set(((Camera)this.cameras.get(i)).getLocation());
            }
            this.updateLOD(this.cameraLocations, this.lodCalculator);
        }
    }

    public void detachAndCleanUpControl() {
        if (this.indexer != null) {
            this.indexer.cancel(true);
            this.indexer = null;
        }
        this.getSpatial().removeControl((Control)this);
    }

    protected void updateLOD(LodCalculator lodCalculator) {
        if (this.getSpatial() == null || this.camera == null) {
            return;
        }
        this.updateQuadLODs();
        if (this.updateLodOffCount(lodCalculator)) {
            return;
        }
        Vector3f currentLocation = this.camera.getLocation();
        if (!this.forceUpdate && this.previousCameraLocation.equals((Object)currentLocation) && !lodCalculator.isLodOff()) {
            return;
        }
        this.previousCameraLocation.set(currentLocation);
        this.forceUpdate = false;
        if (!this.lodCalcRunning.compareAndSet(false, true)) {
            return;
        }
        this.prepareTerrain();
        TerrainExecutorService executorService = TerrainExecutorService.getInstance();
        this.indexer = executorService.submit(this.createLodUpdateTask(Collections.singletonList(currentLocation), lodCalculator));
    }

    protected void updateLOD(SafeArrayList<Vector3f> locations, LodCalculator lodCalculator) {
        int i;
        if (this.getSpatial() == null || locations.isEmpty()) {
            return;
        }
        this.updateQuadLODs();
        if (this.updateLodOffCount(lodCalculator)) {
            return;
        }
        if (!this.forceUpdate && locations.equals(this.lastCameraLocations) && !lodCalculator.isLodOff()) {
            return;
        }
        if (this.lastCameraLocations.size() != locations.size()) {
            this.lastCameraLocations.clear();
            for (i = 0; i < locations.size(); ++i) {
                this.lastCameraLocations.add((Object)new Vector3f());
            }
        }
        for (i = 0; i < locations.size(); ++i) {
            ((Vector3f)this.lastCameraLocations.get(i)).set((Vector3f)locations.get(i));
        }
        this.forceUpdate = false;
        if (!this.lodCalcRunning.compareAndSet(false, true)) {
            return;
        }
        this.prepareTerrain();
        TerrainExecutorService executorService = TerrainExecutorService.getInstance();
        this.indexer = executorService.submit(this.createLodUpdateTask(this.cloneVectorList(locations), lodCalculator));
    }

    protected boolean updateLodOffCount(LodCalculator lodCalculator) {
        if (lodCalculator.isLodOff()) {
            if (this.lodOffCount == 1) {
                return true;
            }
            ++this.lodOffCount;
        } else {
            this.lodOffCount = 0;
        }
        return false;
    }

    public void forceUpdate() {
        this.forceUpdate = true;
    }

    protected void prepareTerrain() {
        TerrainQuad terrain = (TerrainQuad)this.getSpatial();
        terrain.cacheTerrainTransforms();
    }

    protected UpdateLOD createLodUpdateTask(List<Vector3f> locations, LodCalculator lodCalculator) {
        return new UpdateLOD(locations, lodCalculator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateQuadLODs() {
        if (this.indexer == null || !this.indexer.isDone()) {
            return;
        }
        try {
            HashMap<String, UpdatedTerrainPatch> updated = this.indexer.get();
            if (updated != null) {
                for (UpdatedTerrainPatch utp : updated.values()) {
                    utp.updateAll();
                }
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            Logger.getLogger(TerrainLodControl.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            this.indexer = null;
        }
    }

    private List<Vector3f> cloneVectorList(SafeArrayList<Vector3f> locations) {
        ArrayList<Vector3f> cloned = new ArrayList<Vector3f>(locations.size());
        for (Vector3f location : (Vector3f[])locations.getArray()) {
            cloned.add(location.clone());
        }
        return cloned;
    }

    public Object jmeClone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public void cloneFields(Cloner cloner, Object original) {
        super.cloneFields(cloner, original);
        this.lodCalculator = (LodCalculator)cloner.clone((Object)this.lodCalculator);
        this.cameras = new SafeArrayList(Camera.class, this.cameras);
        this.cameraLocations = new SafeArrayList(Vector3f.class);
        this.lastCameraLocations = new SafeArrayList(Vector3f.class);
        this.lodCalcRunning = new AtomicBoolean();
        this.previousCameraLocation = new Vector3f();
    }

    public void setCamera(Camera camera) {
        this.cameras.clear();
        this.cameras.add((Object)camera);
    }

    public void setCameras(List<Camera> cameras) {
        this.cameras.clear();
        this.cameras.addAll(cameras);
    }

    public void setSpatial(Spatial spatial) {
        super.setSpatial(spatial);
        if (spatial instanceof Terrain) {
            this.terrain = (Terrain)spatial;
        }
    }

    public void setTerrain(Terrain terrain) {
        this.terrain = terrain;
    }

    public LodCalculator getLodCalculator() {
        return this.lodCalculator;
    }

    public void setLodCalculator(LodCalculator lodCalculator) {
        this.lodCalculator = lodCalculator;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (!enabled) {
            this.hasResetLod = false;
        } else {
            this.hasResetLod = true;
            this.lodCalculator.turnOnLod();
        }
    }

    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule((Savable)this);
        oc.write((Savable)((Node)this.terrain), "terrain", null);
        oc.write((Savable)this.lodCalculator, "lodCalculator", null);
        oc.write(this.useRenderCamera, "useRenderCamera", false);
    }

    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule((Savable)this);
        this.terrain = (Terrain)ic.readSavable("terrain", null);
        this.lodCalculator = (LodCalculator)ic.readSavable("lodCalculator", (Savable)new DistanceLodCalculator());
        this.useRenderCamera = ic.readBoolean("useRenderCamera", false);
    }

    protected class UpdateLOD
    implements Callable<HashMap<String, UpdatedTerrainPatch>> {
        protected final List<Vector3f> camLocations;
        protected final LodCalculator lodCalculator;

        protected UpdateLOD(List<Vector3f> camLocations, LodCalculator lodCalculator) {
            this.camLocations = camLocations;
            this.lodCalculator = lodCalculator;
        }

        @Override
        public HashMap<String, UpdatedTerrainPatch> call() throws Exception {
            HashMap<String, UpdatedTerrainPatch> updated;
            TerrainQuad terrainQuad = (TerrainQuad)TerrainLodControl.this.getSpatial();
            boolean lodChanged = terrainQuad.calculateLod(this.camLocations, updated = new HashMap<String, UpdatedTerrainPatch>(), this.lodCalculator);
            if (!lodChanged) {
                TerrainLodControl.this.lodCalcRunning.set(false);
                return null;
            }
            terrainQuad.findNeighboursLod(updated);
            terrainQuad.fixEdges(updated);
            terrainQuad.reIndexPages(updated, this.lodCalculator.usesVariableLod());
            TerrainLodControl.this.lodCalcRunning.set(false);
            return updated;
        }
    }
}

