/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.util;

import com.bulletphysics.util.ObjectArrayList;
import java.util.HashMap;
import java.util.Map;

public class ObjectPool<T> {
    private final Class<T> cls;
    private final ObjectArrayList<T> list = new ObjectArrayList();
    private static final ThreadLocal<Map> threadLocal = new ThreadLocal<Map>(){

        @Override
        protected Map initialValue() {
            return new HashMap();
        }
    };

    public ObjectPool(Class<T> cls) {
        this.cls = cls;
    }

    private T create() {
        try {
            return this.cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException(e);
        }
    }

    public T get() {
        if (this.list.size() > 0) {
            return this.list.remove(this.list.size() - 1);
        }
        return this.create();
    }

    public void release(T obj) {
        this.list.add(obj);
    }

    public static <T> ObjectPool<T> get(Class<T> cls) {
        Map map = threadLocal.get();
        ObjectPool<T> pool = (ObjectPool<T>)map.get(cls);
        if (pool == null) {
            pool = new ObjectPool<T>(cls);
            map.put(cls, pool);
        }
        return pool;
    }

    public static void cleanCurrentThread() {
        threadLocal.remove();
    }
}

