/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.gltf;

import com.jme3.plugins.json.JsonArray;
import com.jme3.plugins.json.JsonElement;
import com.jme3.plugins.json.JsonObject;
import com.jme3.plugins.json.JsonPrimitive;
import com.jme3.scene.Spatial;
import com.jme3.scene.plugins.gltf.ExtrasLoader;
import com.jme3.scene.plugins.gltf.GltfLoader;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UserDataLoader
implements ExtrasLoader {
    private static final Logger log = Logger.getLogger(UserDataLoader.class.getName());

    @Override
    public Object handleExtras(GltfLoader loader, String parentName, JsonElement parent, JsonElement extras, Object input) {
        log.fine("handleExtras(" + loader + ", " + parentName + ", " + parent + ", " + extras + ", " + input + ")");
        if (!(extras instanceof JsonObject)) {
            log.warning("Skipping extras:" + extras);
            return input;
        }
        JsonObject jo = extras.getAsJsonObject();
        this.apply(input, jo);
        return input;
    }

    protected void apply(Object input, JsonObject extras) {
        if (input == null) {
            return;
        }
        if (input.getClass().isArray()) {
            this.applyToArray(input, extras);
        } else if (input instanceof Spatial) {
            this.applyToSpatial((Spatial)input, extras);
        } else {
            log.warning("Unhandled input type:" + input.getClass());
        }
    }

    protected void applyToArray(Object array, JsonObject extras) {
        int size = Array.getLength(array);
        for (int i = 0; i < size; ++i) {
            Object o = Array.get(array, i);
            log.fine("processing array[" + i + "]:" + o);
            this.apply(o, extras);
        }
    }

    protected void applyToSpatial(Spatial spatial, JsonObject extras) {
        for (Map.Entry el : extras.entrySet()) {
            log.fine(el.toString());
            Object val = this.toAttribute((JsonElement)el.getValue(), false);
            if (log.isLoggable(Level.FINE)) {
                log.fine("setUserData(" + (String)el.getKey() + ", " + val + ")");
            }
            spatial.setUserData((String)el.getKey(), val);
        }
    }

    protected Object toAttribute(JsonElement el, boolean nested) {
        if (el == null) {
            return null;
        }
        if (el instanceof JsonObject) {
            return this.toAttribute(el.getAsJsonObject(), nested);
        }
        if (el instanceof JsonArray) {
            return this.toAttribute(el.getAsJsonArray(), nested);
        }
        if (el instanceof JsonPrimitive) {
            return this.toAttribute(el.getAsJsonPrimitive(), nested);
        }
        log.warning("Unhandled extras element:" + el);
        return null;
    }

    protected Object toAttribute(JsonObject jo, boolean nested) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry el : jo.entrySet()) {
            result.put((String)el.getKey(), this.toAttribute((JsonElement)el.getValue(), true));
        }
        return result;
    }

    protected Object toAttribute(JsonArray ja, boolean nested) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (JsonElement el : ja) {
            result.add(this.toAttribute(el, true));
        }
        return result;
    }

    protected Object toAttribute(JsonPrimitive jp, boolean nested) {
        if (jp.isBoolean()) {
            return jp.getAsBoolean();
        }
        if (jp.isNumber()) {
            if (nested) {
                return jp.getAsString();
            }
            Number num = jp.getAsNumber();
            return num.doubleValue();
        }
        if (jp.isString()) {
            return jp.getAsString();
        }
        log.warning("Unhandled primitive:" + jp);
        return null;
    }
}

