/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.gltf;

import com.jme3.material.MatParam;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.scene.plugins.gltf.MaterialAdapter;

public abstract class PBRMaterialAdapter
extends MaterialAdapter {
    public static final float MASK_ALPHA_DISCARD = 0.5f;

    public PBRMaterialAdapter() {
        this.addParamMapping("normalTexture", "NormalMap");
        this.addParamMapping("normalScale", "NormalScale");
        this.addParamMapping("occlusionTexture", "LightMap");
        this.addParamMapping("occlusionStrength", "AoStrength");
        this.addParamMapping("emissiveTexture", "EmissiveMap");
        this.addParamMapping("emissiveFactor", "Emissive");
        this.addParamMapping("alphaMode", "alpha");
        this.addParamMapping("alphaCutoff", "AlphaDiscardThreshold");
        this.addParamMapping("doubleSided", "doubleSided");
    }

    @Override
    protected String getMaterialDefPath() {
        return "Common/MatDefs/Light/PBRLighting.j3md";
    }

    @Override
    protected void initDefaultMatParams(Material material) {
        material.setFloat("EmissiveIntensity", 1.0f);
    }

    @Override
    protected MatParam adaptMatParam(MatParam param) {
        if (param.getName().equals("alpha")) {
            String alphaMode;
            switch (alphaMode = (String)param.getValue()) {
                case "MASK": {
                    this.getMaterial().setFloat("AlphaDiscardThreshold", 0.5f);
                    break;
                }
                case "BLEND": {
                    this.getMaterial().getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
                }
            }
            return null;
        }
        if (param.getName().equals("doubleSided")) {
            boolean doubleSided = (Boolean)param.getValue();
            if (doubleSided) {
                this.getMaterial().getAdditionalRenderState().setFaceCullMode(RenderState.FaceCullMode.Off);
            }
            return null;
        }
        if (param.getName().equals("NormalMap")) {
            this.getMaterial().setFloat("NormalType", 1.0f);
        } else if (param.getName().equals("LightMap")) {
            this.getMaterial().setBoolean("LightMapAsAOMap", true);
        } else if (param.getName().equals("alphaCutoff")) {
            this.getMaterial().setFloat("AlphaDiscardThreshold", ((Float)param.getValue()).floatValue());
        }
        return param;
    }
}

