/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.fbx.objects;

import com.jme3.animation.Bone;
import com.jme3.animation.Skeleton;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.Matrix4f;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.plugins.fbx.RotationOrder;
import com.jme3.scene.plugins.fbx.SceneLoader;
import com.jme3.scene.plugins.fbx.file.FbxElement;
import com.jme3.scene.plugins.fbx.objects.FbxAnimNode;
import com.jme3.scene.plugins.fbx.objects.FbxCluster;
import com.jme3.scene.plugins.fbx.objects.FbxMaterial;
import com.jme3.scene.plugins.fbx.objects.FbxMesh;
import com.jme3.scene.plugins.fbx.objects.FbxObject;
import java.util.HashMap;
import java.util.Map;

public class FbxNode
extends FbxObject {
    public RenderState.FaceCullMode cullMode = RenderState.FaceCullMode.Back;
    public Transform localTransform;
    public Node node;
    public FbxNode parentFbxNode;
    public boolean rotationActive = false;
    public RotationOrder rotationOrder = RotationOrder.EULER_XYZ;
    public Matrix4f bindTransform = null;
    public int boneIndex;
    public Map<Long, FbxAnimNode> animTranslations = new HashMap<Long, FbxAnimNode>();
    public Map<Long, FbxAnimNode> animRotations = new HashMap<Long, FbxAnimNode>();
    public Map<Long, FbxAnimNode> animScales = new HashMap<Long, FbxAnimNode>();
    public Bone bone;
    private FbxAnimNode lastAnimTranslation;
    private FbxAnimNode lastAnimRotation;
    private FbxAnimNode lastAnimScale;
    private FbxMesh mesh;
    public Map<Long, FbxCluster> skinToCluster = new HashMap<Long, FbxCluster>();

    public FbxNode(SceneLoader scene, FbxElement element) {
        super(scene, element);
        this.node = new Node(this.name);
        Vector3f translationLocalRaw = new Vector3f();
        Vector3f rotationOffsetRaw = new Vector3f();
        Vector3f rotationPivotRaw = new Vector3f();
        Vector3f rotationPreRaw = new Vector3f();
        Vector3f rotationLocalRaw = new Vector3f();
        Vector3f rotationPostRaw = new Vector3f();
        Vector3f scaleOffsetRaw = new Vector3f();
        Vector3f scalePivotRaw = new Vector3f();
        Vector3f scaleLocalRaw = new Vector3f(1.0f, 1.0f, 1.0f);
        for (FbxElement prop : element.getFbxProperties()) {
            String propName;
            switch (propName = (String)prop.properties.get(0)) {
                case "RotationOrder": {
                    this.rotationOrder = RotationOrder.values[(Integer)prop.properties.get(4)];
                    break;
                }
                case "Lcl Translation": {
                    FbxNode.readVectorFromProp(translationLocalRaw, prop);
                    break;
                }
                case "Lcl Rotation": {
                    FbxNode.readVectorFromProp(rotationLocalRaw, prop);
                    break;
                }
                case "Lcl Scaling": {
                    FbxNode.readVectorFromProp(scaleLocalRaw, prop);
                    break;
                }
                case "PreRotation": {
                    FbxNode.readVectorFromProp(rotationPreRaw, prop);
                    break;
                }
                case "RotationActive": {
                    this.rotationActive = ((Number)prop.properties.get(4)).intValue() == 1;
                    break;
                }
                case "RotationPivot": {
                    FbxNode.readVectorFromProp(rotationPivotRaw, prop);
                    break;
                }
                case "PostRotation": {
                    FbxNode.readVectorFromProp(rotationPostRaw, prop);
                    break;
                }
                case "ScaleOffset": {
                    FbxNode.readVectorFromProp(scaleOffsetRaw, prop);
                    break;
                }
                case "ScalePivot": {
                    FbxNode.readVectorFromProp(scalePivotRaw, prop);
                    break;
                }
                case "U": {
                    Object userDataValue;
                    String userDataKey = (String)prop.properties.get(0);
                    String userDataType = (String)prop.properties.get(1);
                    if (userDataType.equals("KString")) {
                        userDataValue = prop.properties.get(4);
                    } else if (userDataType.equals("int")) {
                        userDataValue = prop.properties.get(4);
                    } else if (userDataType.equals("double")) {
                        userDataValue = Float.valueOf(((Double)prop.properties.get(4)).floatValue());
                    } else if (userDataType.equals("Vector")) {
                        double x = (Double)prop.properties.get(4);
                        double y = (Double)prop.properties.get(5);
                        double z = (Double)prop.properties.get(6);
                        userDataValue = new Vector3f((float)x, (float)y, (float)z);
                    } else {
                        scene.warning("Unsupported user data type: " + userDataType + ". Ignoring.");
                        break;
                    }
                    this.node.setUserData(userDataKey, userDataValue);
                }
            }
        }
        FbxElement cullingElement = element.getChildById("Culling");
        if (cullingElement != null && cullingElement.properties.get(0).equals("CullingOff")) {
            this.cullMode = RenderState.FaceCullMode.Off;
        }
        RotationOrder rotOrder = this.rotationActive ? this.rotationOrder : RotationOrder.EULER_XYZ;
        Matrix4f transformMatrix = new Matrix4f();
        transformMatrix.setTranslation(translationLocalRaw.x + rotationOffsetRaw.x + rotationPivotRaw.x, translationLocalRaw.y + rotationOffsetRaw.y + rotationPivotRaw.y, translationLocalRaw.z + rotationOffsetRaw.z + rotationPivotRaw.z);
        if (this.rotationActive) {
            Quaternion postRotation = rotOrder.rotate(rotationPostRaw.x, rotationPostRaw.y, rotationPostRaw.z);
            Quaternion localRotation = rotOrder.rotate(rotationLocalRaw.x, rotationLocalRaw.y, rotationLocalRaw.z);
            Quaternion preRotation = rotOrder.rotate(rotationPreRaw.x, rotationPreRaw.y, rotationPreRaw.z);
            postRotation.multLocal(localRotation).multLocal(preRotation);
            transformMatrix.multLocal(postRotation);
        } else {
            transformMatrix.multLocal(rotOrder.rotate(rotationLocalRaw.x, rotationLocalRaw.y, rotationLocalRaw.z));
        }
        Matrix4f mat = new Matrix4f();
        mat.setTranslation(scaleOffsetRaw.x + scalePivotRaw.x - rotationPivotRaw.x, scaleOffsetRaw.y + scalePivotRaw.y - rotationPivotRaw.y, scaleOffsetRaw.z + scalePivotRaw.z - rotationPivotRaw.z);
        transformMatrix.multLocal(mat);
        transformMatrix.scale(scaleLocalRaw);
        transformMatrix.scale(new Vector3f(scene.unitSize, scene.unitSize, scene.unitSize));
        mat.setTranslation(scalePivotRaw.negate());
        transformMatrix.multLocal(mat);
        this.localTransform = new Transform(transformMatrix.toTranslationVector(), transformMatrix.toRotationQuat(), transformMatrix.toScaleVector());
        this.node.setLocalTransform(this.localTransform);
    }

    @Override
    public void linkToZero() {
        this.scene.sceneNode.attachChild((Spatial)this.node);
    }

    public void setSkeleton(Skeleton skeleton) {
        if (this.bone != null) {
            this.boneIndex = skeleton.getBoneIndex(this.bone);
        }
    }

    public void buildBindPoseBoneTransform() {
        if (this.bone != null) {
            Matrix4f t = this.bindTransform;
            if (t != null) {
                Matrix4f parentMatrix;
                Matrix4f matrix4f = parentMatrix = this.parentFbxNode != null ? this.parentFbxNode.bindTransform : Matrix4f.IDENTITY;
                if (parentMatrix == null) {
                    parentMatrix = this.node.getLocalToWorldMatrix(null);
                }
                t = parentMatrix.invert().multLocal(t);
                this.bone.setBindTransforms(t.toTranslationVector(), t.toRotationQuat(), t.toScaleVector());
            } else {
                this.bone.setBindTransforms(this.node.getLocalTranslation(), this.node.getLocalRotation(), this.node.getLocalScale());
            }
        }
    }

    @Override
    public void link(FbxObject child, String propertyName) {
        if (child instanceof FbxAnimNode) {
            FbxAnimNode anim = (FbxAnimNode)child;
            switch (propertyName) {
                case "Lcl Translation": {
                    this.animTranslations.put(anim.layerId, anim);
                    this.lastAnimTranslation = anim;
                    break;
                }
                case "Lcl Rotation": {
                    this.animRotations.put(anim.layerId, anim);
                    this.lastAnimRotation = anim;
                    break;
                }
                case "Lcl Scaling": {
                    this.animScales.put(anim.layerId, anim);
                    this.lastAnimScale = anim;
                }
            }
        }
    }

    public FbxAnimNode animTranslation(long layerId) {
        if (layerId == 0L) {
            return this.lastAnimTranslation;
        }
        return this.animTranslations.get(layerId);
    }

    public FbxAnimNode animRotation(long layerId) {
        if (layerId == 0L) {
            return this.lastAnimRotation;
        }
        return this.animRotations.get(layerId);
    }

    public FbxAnimNode animScale(long layerId) {
        if (layerId == 0L) {
            return this.lastAnimScale;
        }
        return this.animScales.get(layerId);
    }

    @Override
    public void link(FbxObject otherObject) {
        if (otherObject instanceof FbxMaterial) {
            FbxMaterial m = (FbxMaterial)otherObject;
            Material mat = m.material;
            if (this.cullMode != RenderState.FaceCullMode.Back) {
                mat.getAdditionalRenderState().setFaceCullMode(this.cullMode);
            }
            for (Geometry g : this.mesh.geometries) {
                if (g.getUserData("FBXMaterial") != null) {
                    if ((Integer)g.getUserData("FBXMaterial") != this.mesh.lastMaterialId) continue;
                    g.setMaterial(mat);
                    continue;
                }
                g.setMaterial(mat);
            }
            ++this.mesh.lastMaterialId;
        } else if (otherObject instanceof FbxNode) {
            FbxNode n = (FbxNode)otherObject;
            this.node.attachChild((Spatial)n.node);
            n.parentFbxNode = this;
            if (this.isLimb() && n.isLimb()) {
                if (this.bone == null) {
                    this.bone = new Bone(this.name);
                }
                if (n.bone == null) {
                    n.bone = new Bone(n.name);
                }
                this.bone.addChild(n.bone);
            }
        } else if (otherObject instanceof FbxMesh) {
            FbxMesh m = (FbxMesh)otherObject;
            m.setParent(this.node);
            m.parent = this;
            this.mesh = m;
        }
    }

    public boolean isLimb() {
        return this.type.equals("LimbNode");
    }
}

