/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.fbx.obj;

import com.jme3.asset.AssetManager;
import com.jme3.scene.plugins.fbx.anim.FbxAnimCurve;
import com.jme3.scene.plugins.fbx.anim.FbxAnimCurveNode;
import com.jme3.scene.plugins.fbx.anim.FbxAnimLayer;
import com.jme3.scene.plugins.fbx.anim.FbxAnimStack;
import com.jme3.scene.plugins.fbx.anim.FbxBindPose;
import com.jme3.scene.plugins.fbx.anim.FbxCluster;
import com.jme3.scene.plugins.fbx.anim.FbxLimbNode;
import com.jme3.scene.plugins.fbx.anim.FbxSkinDeformer;
import com.jme3.scene.plugins.fbx.file.FbxElement;
import com.jme3.scene.plugins.fbx.material.FbxImage;
import com.jme3.scene.plugins.fbx.material.FbxMaterial;
import com.jme3.scene.plugins.fbx.material.FbxTexture;
import com.jme3.scene.plugins.fbx.mesh.FbxMesh;
import com.jme3.scene.plugins.fbx.node.FbxNode;
import com.jme3.scene.plugins.fbx.node.FbxNullAttribute;
import com.jme3.scene.plugins.fbx.obj.FbxObject;
import com.jme3.scene.plugins.fbx.obj.FbxUnknownObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class FbxObjectFactory {
    private static final Logger logger = Logger.getLogger(FbxObjectFactory.class.getName());

    private FbxObjectFactory() {
    }

    private static Class<? extends FbxObject> getImplementingClass(String elementName, String subclassName) {
        if (elementName.equals("NodeAttribute")) {
            if (subclassName.equals("Root")) {
                return FbxNullAttribute.class;
            }
            if (subclassName.equals("LimbNode")) {
                return FbxNullAttribute.class;
            }
            if (subclassName.equals("Null")) {
                return FbxNullAttribute.class;
            }
            if (subclassName.equals("IKEffector") || subclassName.equals("FKEffector")) {
                return FbxNullAttribute.class;
            }
            if (subclassName.equals("Light")) {
                return FbxNullAttribute.class;
            }
            if (subclassName.equals("Camera")) {
                return FbxNullAttribute.class;
            }
            logger.log(Level.WARNING, "Unknown object subclass: {0}. Ignoring.", subclassName);
            return FbxUnknownObject.class;
        }
        if (elementName.equals("Geometry") && subclassName.equals("Mesh")) {
            return FbxMesh.class;
        }
        if (elementName.equals("Model")) {
            if (subclassName.equals("LimbNode")) {
                return FbxLimbNode.class;
            }
            return FbxNode.class;
        }
        if (elementName.equals("Pose")) {
            if (subclassName.equals("BindPose")) {
                return FbxBindPose.class;
            }
            logger.log(Level.WARNING, "Unknown object subclass: {0}. Ignoring.", subclassName);
            return FbxUnknownObject.class;
        }
        if (elementName.equals("Material")) {
            return FbxMaterial.class;
        }
        if (elementName.equals("Deformer")) {
            if (subclassName.equals("Skin")) {
                return FbxSkinDeformer.class;
            }
            if (subclassName.equals("Cluster")) {
                return FbxCluster.class;
            }
            logger.log(Level.WARNING, "Unknown deformer subclass: {0}. Ignoring.", subclassName);
            return FbxUnknownObject.class;
        }
        if (elementName.equals("Video")) {
            if (subclassName.equals("Clip")) {
                return FbxImage.class;
            }
            logger.log(Level.WARNING, "Unknown object subclass: {0}. Ignoring.", subclassName);
            return FbxUnknownObject.class;
        }
        if (elementName.equals("Texture")) {
            return FbxTexture.class;
        }
        if (elementName.equals("AnimationStack")) {
            return FbxAnimStack.class;
        }
        if (elementName.equals("AnimationLayer")) {
            return FbxAnimLayer.class;
        }
        if (elementName.equals("AnimationCurveNode")) {
            return FbxAnimCurveNode.class;
        }
        if (elementName.equals("AnimationCurve")) {
            return FbxAnimCurve.class;
        }
        if (elementName.equals("SceneInfo")) {
            return FbxUnknownObject.class;
        }
        logger.log(Level.WARNING, "Unknown object class: {0}. Ignoring.", elementName);
        return FbxUnknownObject.class;
    }

    public static FbxObject createObject(FbxElement element, AssetManager assetManager, String sceneFolderName) {
        String subclassName;
        String elementName = element.id;
        if (element.propertiesTypes.length == 3) {
            subclassName = (String)element.properties.get(2);
        } else if (element.propertiesTypes.length == 2) {
            subclassName = (String)element.properties.get(1);
        } else {
            return null;
        }
        Class<? extends FbxObject> javaFbxClass = FbxObjectFactory.getImplementingClass(elementName, subclassName);
        if (javaFbxClass != null) {
            try {
                Constructor<? extends FbxObject> ctor = javaFbxClass.getConstructor(AssetManager.class, String.class);
                FbxObject obj = ctor.newInstance(assetManager, sceneFolderName);
                obj.fromElement(element);
                String subClassName = elementName + ", " + subclassName;
                if (obj.assetManager == null) {
                    throw new IllegalStateException("FBXObject subclass (" + subClassName + ") forgot to call super() in their constructor");
                }
                if (obj.className == null) {
                    throw new IllegalStateException("FBXObject subclass (" + subClassName + ") forgot to call super.fromElement() in their fromElement() implementation");
                }
                return obj;
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                throw new IllegalStateException(ex);
            }
        }
        return null;
    }
}

