/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.fbx.material;

import com.jme3.math.ColorRGBA;
import com.jme3.scene.plugins.fbx.file.FbxElement;
import com.jme3.scene.plugins.fbx.material.FbxTexture;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FbxMaterialProperties {
    private static final Logger logger = Logger.getLogger(FbxMaterialProperties.class.getName());
    private static final Map<String, FBXMaterialProperty> propertyMetaMap = new HashMap<String, FBXMaterialProperty>();
    private final Map<String, Object> propertyValueMap = new HashMap<String, Object>();

    private static void defineProp(String name, Type type) {
        propertyMetaMap.put(name, new FBXMaterialProperty(name, type));
    }

    private static void defineAlias(String alias, String name) {
        propertyMetaMap.put(alias, propertyMetaMap.get(name));
    }

    public void setPropertyTexture(String name, FbxTexture texture) {
        FBXMaterialProperty prop = propertyMetaMap.get(name);
        if (prop == null) {
            logger.log(Level.WARNING, "Unknown FBX material property '{0}'", name);
            return;
        }
        if (this.propertyValueMap.get(name) instanceof FbxTexture) {
            name = name + "2";
        }
        this.propertyValueMap.put(name, texture);
    }

    public void setPropertyFromElement(FbxElement propertyElement) {
        String name = (String)propertyElement.properties.get(0);
        FBXMaterialProperty prop = propertyMetaMap.get(name);
        if (prop == null) {
            logger.log(Level.WARNING, "Unknown FBX material property ''{0}''", name);
            return;
        }
        String realName = prop.name;
        switch (prop.type) {
            case Alpha: 
            case Factor: 
            case Texture2DOrFactor: 
            case Texture2DOrAlpha: {
                double value = (Double)propertyElement.properties.get(4);
                this.propertyValueMap.put(realName, Float.valueOf((float)value));
                break;
            }
            case Color: 
            case Texture2DOrColor: {
                double x = (Double)propertyElement.properties.get(4);
                double y = (Double)propertyElement.properties.get(5);
                double z = (Double)propertyElement.properties.get(6);
                ColorRGBA color = new ColorRGBA((float)x, (float)y, (float)z, 1.0f);
                this.propertyValueMap.put(realName, color);
                break;
            }
            default: {
                logger.log(Level.WARNING, "FBX material property ''{0}'' requires a texture.", name);
            }
        }
    }

    public Object getProperty(String name) {
        return this.propertyValueMap.get(name);
    }

    static {
        FbxMaterialProperties.defineProp("AmbientColor", Type.Color);
        FbxMaterialProperties.defineProp("AmbientFactor", Type.Factor);
        FbxMaterialProperties.defineAlias("Ambient", "AmbientColor");
        FbxMaterialProperties.defineProp("DiffuseColor", Type.Texture2DOrColor);
        FbxMaterialProperties.defineProp("DiffuseFactor", Type.Factor);
        FbxMaterialProperties.defineAlias("Diffuse", "DiffuseColor");
        FbxMaterialProperties.defineProp("SpecularColor", Type.Texture2DOrColor);
        FbxMaterialProperties.defineProp("SpecularFactor", Type.Factor);
        FbxMaterialProperties.defineAlias("Specular", "SpecularColor");
        FbxMaterialProperties.defineProp("TransparentColor", Type.Texture2DOrAlpha);
        FbxMaterialProperties.defineProp("TransparencyFactor", Type.Alpha);
        FbxMaterialProperties.defineAlias("Opacity", "TransparencyFactor");
        FbxMaterialProperties.defineProp("EmissiveColor", Type.Texture2DOrColor);
        FbxMaterialProperties.defineProp("EmissiveFactor", Type.Factor);
        FbxMaterialProperties.defineAlias("Emissive", "EmissiveColor");
        FbxMaterialProperties.defineProp("Shininess", Type.Factor);
        FbxMaterialProperties.defineAlias("ShininessExponent", "Shininess");
        FbxMaterialProperties.defineProp("NormalMap", Type.Texture2D);
        FbxMaterialProperties.defineAlias("Normal", "NormalMap");
        FbxMaterialProperties.defineProp("ReflectionColor", Type.Texture2DOrColor);
        FbxMaterialProperties.defineProp("Reflectivity", Type.Factor);
        FbxMaterialProperties.defineAlias("ReflectionFactor", "Reflectivity");
        FbxMaterialProperties.defineProp("ShadingModel", Type.Ignore);
        FbxMaterialProperties.defineProp("MultiLayer", Type.Ignore);
        FbxMaterialProperties.defineProp("Bump", Type.Texture2DOrColor);
        FbxMaterialProperties.defineProp("BumpFactor", Type.Factor);
        FbxMaterialProperties.defineProp("DisplacementColor", Type.Color);
        FbxMaterialProperties.defineProp("DisplacementFactor", Type.Factor);
    }

    private static class FBXMaterialProperty {
        private final String name;
        private final Type type;

        public FBXMaterialProperty(String name, Type type) {
            this.name = name;
            this.type = type;
        }
    }

    private static enum Type {
        Color,
        Alpha,
        Factor,
        Texture2DOrColor,
        Texture2DOrAlpha,
        Texture2DOrFactor,
        Texture2D,
        TextureCubeMap,
        Ignore;

    }
}

