/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.util.struct;

import com.jme3.shader.bufferobject.BufferObject;
import com.jme3.shader.bufferobject.BufferRegion;
import com.jme3.shader.bufferobject.layout.BufferLayout;
import com.jme3.shader.bufferobject.layout.Std140Layout;
import com.jme3.util.struct.Struct;
import com.jme3.util.struct.StructField;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StructUtils {
    private static final Logger logger = Logger.getLogger(StructUtils.class.getName());
    private static final Comparator<StructField<?>> fieldComparator = new Comparator<StructField<?>>(){

        @Override
        public int compare(StructField<?> a, StructField<?> b) {
            return a.getPosition() - b.getPosition();
        }
    };

    public static List<StructField<?>> sortFields(List<StructField<?>> fields) {
        fields.sort(fieldComparator);
        return fields;
    }

    public static List<StructField<?>> getFields(Struct struct) {
        return StructUtils.getFields(struct, 0, null);
    }

    public static List<StructField<?>> getFields(Struct struct, ArrayList<Field> classFields) {
        return StructUtils.getFields(struct, 0, classFields);
    }

    private static List<StructField<?>> getFields(Struct struct, int depth, ArrayList<Field> classFields) {
        ArrayList<StructField<?>> structFields = new ArrayList();
        Class<?> structClass = struct.getClass();
        try {
            int i;
            Field[] fields;
            for (Field field : fields = structClass.getDeclaredFields()) {
                field.setAccessible(true);
                Object o = field.get(struct);
                if (!(o instanceof StructField)) continue;
                if (classFields != null) {
                    classFields.add(field);
                }
                StructField so = (StructField)o;
                structFields.add(so);
            }
            StructUtils.sortFields(structFields);
            ArrayList expandedStructFields = new ArrayList();
            for (i = 0; i < structFields.size(); ++i) {
                StructField<?> so = structFields.get(i);
                if (so.getValue() instanceof Struct) {
                    List<StructField<?>> list = StructUtils.getFields((Struct)so.getValue(), depth + 1, classFields);
                    expandedStructFields.addAll(list);
                    continue;
                }
                if (so.getValue().getClass().isArray() && Struct.class.isAssignableFrom(so.getValue().getClass().getComponentType())) {
                    Struct[] structArray = (Struct[])so.getValue();
                    for (int j = 0; j < structArray.length; ++j) {
                        Struct sub = structArray[j];
                        List<StructField<?>> subStruct = StructUtils.getFields(sub, depth + 1, classFields);
                        expandedStructFields.addAll(subStruct);
                    }
                    continue;
                }
                so.setDepth(depth);
                so.setGroup(struct.hashCode());
                expandedStructFields.add(so);
            }
            structFields = expandedStructFields;
            i = 0;
            for (StructField<Object> structField : structFields) {
                structField.setPosition(i);
                ++i;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        assert (structFields.size() != 0);
        return structFields;
    }

    public static BufferObject setStd140BufferLayout(List<StructField<?>> fields, Std140Layout serializer, BufferObject out) {
        int pos = -1;
        ArrayList<BufferRegion> regions = new ArrayList<BufferRegion>();
        for (int i = 0; i < fields.size(); ++i) {
            StructField<?> f = fields.get(i);
            Object v = f.getValue();
            int basicAlignment = serializer.getBasicAlignment(v);
            int length = serializer.estimateSize(v);
            int start = serializer.align(pos + 1, basicAlignment);
            int end = start + length - 1;
            if (i == fields.size() - 1 || f.getGroup() != fields.get(i + 1).getGroup()) {
                end = serializer.align(end, 16) - 1;
            }
            BufferRegion r = new BufferRegion(start, end);
            regions.add(r);
            pos = end;
        }
        out.setRegions(regions);
        return out;
    }

    public static void updateBufferData(List<StructField<?>> fields, boolean forceUpdate, BufferLayout layout, BufferObject out) {
        boolean updateNeeded = false;
        for (StructField<?> f : fields) {
            if (forceUpdate || f.isUpdateNeeded()) {
                BufferRegion region = out.getRegion(f.getPosition());
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "Serialize {0} in {1} ", new Object[]{f, region});
                }
                layout.write(region.getData(), f.getValue());
                region.markDirty();
                f.clearUpdateNeeded();
                updateNeeded = true;
                continue;
            }
            if (!logger.isLoggable(Level.FINER)) continue;
            logger.log(Level.FINER, "Already up to date. Skip {0}  ", new Object[]{f});
        }
        if (updateNeeded) {
            out.setUpdateNeeded(false);
        }
    }
}

