/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.util.res;

import com.jme3.util.res.ResourceLoader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Resources {
    public static final String PROPERTY_RESOURCE_LOADER_IMPLEMENTATION = "com.jme3.ResourceLoaderImplementation";
    private static final String DEFAULT_IMPL = "com.jme3.util.res.DefaultResourceLoader";
    private static final Logger LOGGER = Logger.getLogger(Resources.class.getName());
    private static ResourceLoader impl = null;

    private static Class<? extends ResourceLoader> findResourceLoaderClass(String className) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
        }
        catch (Throwable e) {
            LOGGER.log(Level.WARNING, "Unable to access {0}", className);
        }
        if (clazz != null && !ResourceLoader.class.isAssignableFrom(clazz)) {
            LOGGER.log(Level.WARNING, "{0} does not implement {1}", new Object[]{className, ResourceLoader.class.getName()});
            clazz = null;
        }
        return clazz;
    }

    private static ResourceLoader getResourceLoader() {
        if (impl != null) {
            return impl;
        }
        Class<? extends ResourceLoader> clazz = null;
        String userDefinedImpl = System.getProperty(PROPERTY_RESOURCE_LOADER_IMPLEMENTATION, null);
        if (userDefinedImpl != null) {
            LOGGER.log(Level.FINE, "Loading user defined ResourceLoader implementation {0}", userDefinedImpl);
            clazz = Resources.findResourceLoaderClass(userDefinedImpl);
        }
        if (clazz == null) {
            LOGGER.log(Level.FINE, "No usable user defined ResourceLoader implementation found, using default implementation {0}", DEFAULT_IMPL);
            clazz = Resources.findResourceLoaderClass(DEFAULT_IMPL);
        }
        if (clazz == null) {
            throw new RuntimeException("No ResourceLoader implementation found");
        }
        try {
            impl = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable e) {
            throw new RuntimeException("Could not instantiate ResourceLoader class " + clazz.getName(), e);
        }
        return impl;
    }

    public static void setResourceLoader(ResourceLoader impl) {
        Resources.impl = impl;
    }

    public static URL getResource(String path) {
        return Resources.getResourceLoader().getResource(path, null);
    }

    public static URL getResource(String path, Class<?> parent) {
        return Resources.getResourceLoader().getResource(path, parent);
    }

    public static InputStream getResourceAsStream(String path) {
        return Resources.getResourceLoader().getResourceAsStream(path, null);
    }

    public static InputStream getResourceAsStream(String path, Class<?> parent) {
        return Resources.getResourceLoader().getResourceAsStream(path, parent);
    }

    public static Enumeration<URL> getResources(String path) throws IOException {
        return Resources.getResourceLoader().getResources(path);
    }
}

