/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class SafeArrayList<E>
implements List<E>,
Cloneable {
    private final Class<E> elementType;
    private List<E> buffer;
    private E[] backingArray;
    private int size = 0;

    public SafeArrayList(Class<E> elementType) {
        this.elementType = elementType;
    }

    public SafeArrayList(Class<E> elementType, int capacity) {
        this.elementType = elementType;
        this.buffer = new ArrayList(capacity);
    }

    public SafeArrayList(Class<E> elementType, Collection<? extends E> collection) {
        this.elementType = elementType;
        this.buffer = new ArrayList<E>(collection);
        this.size = this.buffer.size();
    }

    public SafeArrayList<E> clone() {
        try {
            SafeArrayList clone = (SafeArrayList)super.clone();
            if (this.backingArray != null) {
                clone.backingArray = (Object[])this.backingArray.clone();
            }
            if (this.buffer != null) {
                clone.buffer = (List)((ArrayList)this.buffer).clone();
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    protected final <T> T[] createArray(Class<T> type, int size) {
        return (Object[])Array.newInstance(type, size);
    }

    protected final E[] createArray(int size) {
        return this.createArray(this.elementType, size);
    }

    public final E[] getArray() {
        if (this.backingArray != null) {
            return this.backingArray;
        }
        if (this.buffer == null) {
            this.backingArray = this.createArray(0);
        } else {
            this.backingArray = this.buffer.toArray(this.createArray(this.buffer.size()));
            this.buffer = null;
        }
        return this.backingArray;
    }

    protected final List<E> getBuffer() {
        if (this.buffer != null) {
            return this.buffer;
        }
        if (this.backingArray == null) {
            this.buffer = new ArrayList();
        } else {
            this.buffer = new ArrayList<E>(Arrays.asList(this.backingArray));
            this.backingArray = null;
        }
        return this.buffer;
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public Iterator<E> iterator() {
        return this.listIterator();
    }

    @Override
    public Object[] toArray() {
        return this.getArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        E[] array = this.getArray();
        if (a.length < array.length) {
            return Arrays.copyOf(array, array.length, a.getClass());
        }
        System.arraycopy(array, 0, a, 0, array.length);
        if (a.length > array.length) {
            a[array.length] = null;
        }
        return a;
    }

    @Override
    public boolean add(E e) {
        boolean result = this.getBuffer().add(e);
        this.size = this.getBuffer().size();
        return result;
    }

    @Override
    public boolean remove(Object o) {
        boolean result = this.getBuffer().remove(o);
        this.size = this.getBuffer().size();
        return result;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return Arrays.asList(this.getArray()).containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean result = this.getBuffer().addAll(c);
        this.size = this.getBuffer().size();
        return result;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        boolean result = this.getBuffer().addAll(index, c);
        this.size = this.getBuffer().size();
        return result;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean result = this.getBuffer().removeAll(c);
        this.size = this.getBuffer().size();
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean result = this.getBuffer().retainAll(c);
        this.size = this.getBuffer().size();
        return result;
    }

    @Override
    public void clear() {
        this.getBuffer().clear();
        this.size = 0;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SafeArrayList) {
            Object[] targetArray = ((SafeArrayList)o).getArray();
            Object[] array = this.getArray();
            return Arrays.equals(targetArray, array);
        }
        if (!(o instanceof List)) {
            return false;
        }
        List other = (List)o;
        Iterator<E> i1 = this.iterator();
        Iterator i2 = other.iterator();
        while (i1.hasNext() && i2.hasNext()) {
            Object o2;
            E o1 = i1.next();
            if (o1 == (o2 = i2.next()) || o1 != null && o1.equals(o2)) continue;
            return false;
        }
        return !i1.hasNext() && !i2.hasNext();
    }

    @Override
    public int hashCode() {
        E[] array = this.getArray();
        int result = 1;
        for (E e : array) {
            result = 31 * result + (e == null ? 0 : e.hashCode());
        }
        return result;
    }

    @Override
    public final E get(int index) {
        if (this.backingArray != null) {
            return this.backingArray[index];
        }
        if (this.buffer != null) {
            return this.buffer.get(index);
        }
        throw new IndexOutOfBoundsException("Index:" + index + ", Size:0");
    }

    @Override
    public E set(int index, E element) {
        return this.getBuffer().set(index, element);
    }

    @Override
    public void add(int index, E element) {
        this.getBuffer().add(index, element);
        this.size = this.getBuffer().size();
    }

    @Override
    public E remove(int index) {
        E result = this.getBuffer().remove(index);
        this.size = this.getBuffer().size();
        return result;
    }

    @Override
    public int indexOf(Object o) {
        E[] array = this.getArray();
        for (int i = 0; i < array.length; ++i) {
            E element = array[i];
            if (element == o) {
                return i;
            }
            if (element == null || !element.equals(o)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        E[] array = this.getArray();
        for (int i = array.length - 1; i >= 0; --i) {
            E element = array[i];
            if (element == o) {
                return i;
            }
            if (element == null || !element.equals(o)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public ListIterator<E> listIterator() {
        return new ArrayIterator<E>(this.getArray(), 0);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new ArrayIterator<E>(this.getArray(), index);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        List<E> raw = Arrays.asList(this.getArray()).subList(fromIndex, toIndex);
        return Collections.unmodifiableList(raw);
    }

    public String toString() {
        E[] array = this.getArray();
        if (array.length == 0) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (int i = 0; i < array.length; ++i) {
            E e;
            if (i > 0) {
                sb.append(", ");
            }
            sb.append((Object)((e = array[i]) == this ? "(this Collection)" : e));
        }
        sb.append(']');
        return sb.toString();
    }

    protected class ArrayIterator<E>
    implements ListIterator<E> {
        private final E[] array;
        private int next;
        private int lastReturned;

        protected ArrayIterator(E[] array, int index) {
            this.array = array;
            this.next = index;
            this.lastReturned = -1;
        }

        @Override
        public boolean hasNext() {
            return this.next != this.array.length;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.next++;
            return this.array[this.lastReturned];
        }

        @Override
        public boolean hasPrevious() {
            return this.next != 0;
        }

        @Override
        public E previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.lastReturned = --this.next;
            return this.array[this.lastReturned];
        }

        @Override
        public int nextIndex() {
            return this.next;
        }

        @Override
        public int previousIndex() {
            return this.next - 1;
        }

        @Override
        public void remove() {
            SafeArrayList.this.remove(this.array[this.lastReturned]);
        }

        @Override
        public void set(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(E e) {
            throw new UnsupportedOperationException();
        }
    }
}

