/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.texture;

import com.jme3.asset.AssetKey;
import com.jme3.asset.AssetProcessor;
import com.jme3.asset.TextureKey;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import com.jme3.texture.Texture3D;
import com.jme3.texture.TextureCubeMap;
import java.nio.ByteBuffer;

public class TextureProcessor
implements AssetProcessor {
    @Override
    public Object postProcess(AssetKey key, Object obj) {
        Texture tex;
        TextureKey texKey = (TextureKey)key;
        Image img = (Image)obj;
        if (img == null) {
            return null;
        }
        if (texKey.getTextureTypeHint() == Texture.Type.CubeMap) {
            if (texKey.isFlipY()) {
                ByteBuffer pos_y = img.getData(2);
                img.setData(2, img.getData(3));
                img.setData(3, pos_y);
            }
            tex = new TextureCubeMap();
        } else {
            tex = texKey.getTextureTypeHint() == Texture.Type.ThreeDimensional ? new Texture3D() : new Texture2D();
        }
        if (img.hasMipmaps() || texKey.isGenerateMips()) {
            tex.setMinFilter(Texture.MinFilter.Trilinear);
        }
        tex.setAnisotropicFilter(texKey.getAnisotropy());
        tex.setName(texKey.getName());
        tex.setImage(img);
        return tex;
    }

    @Override
    public Object createClone(Object obj) {
        Texture tex = (Texture)obj;
        return tex.clone();
    }
}

