/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.shader.bufferobject;

import com.jme3.shader.bufferobject.BufferObject;
import com.jme3.shader.bufferobject.BufferRegion;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DirtyRegionsIterator
implements Iterator<BufferRegion> {
    private BufferObject bufferObject;
    private final DirtyRegion dirtyRegion = new DirtyRegion();
    private int pos = 0;

    public DirtyRegionsIterator(BufferObject bufferObject) {
        this.bufferObject = bufferObject;
    }

    public void rewind() {
        this.pos = 0;
    }

    @Override
    public boolean hasNext() {
        return this.pos < this.bufferObject.regions.size();
    }

    @Override
    public BufferRegion next() {
        this.dirtyRegion.bo = this.bufferObject;
        this.dirtyRegion.regions.clear();
        if (this.bufferObject.regions.size() == 0) {
            if (!this.bufferObject.isUpdateNeeded()) {
                return null;
            }
            this.dirtyRegion.fullBufferRegion = true;
            this.dirtyRegion.end = this.bufferObject.getData().limit();
            this.dirtyRegion.start = 0;
            return this.dirtyRegion;
        }
        while (this.pos < this.bufferObject.regions.size()) {
            BufferRegion dr;
            if ((dr = this.bufferObject.regions.get(this.pos++)).isDirty()) {
                if (this.dirtyRegion.regions.size() == 0) {
                    this.dirtyRegion.start = dr.start;
                }
                this.dirtyRegion.end = dr.end;
                this.dirtyRegion.regions.add(dr);
                continue;
            }
            if (this.dirtyRegion.regions.size() == 0) continue;
            break;
        }
        if (this.dirtyRegion.regions.size() == 0) {
            return null;
        }
        this.dirtyRegion.fullBufferRegion = this.dirtyRegion.regions.size() == this.bufferObject.regions.size();
        this.dirtyRegion.markDirty();
        return this.dirtyRegion;
    }

    private static class DirtyRegion
    extends BufferRegion {
        List<BufferRegion> regions = new ArrayList<BufferRegion>();

        private DirtyRegion() {
        }

        @Override
        public ByteBuffer getData() {
            ByteBuffer d = this.bo.getData();
            if (this.source == null || d != this.source || this.slice == null) {
                this.source = d;
                int currentPos = this.source.position();
                int currentLimit = this.source.limit();
                this.source.limit(this.source.capacity());
                this.source.position(0);
                this.slice = this.source.slice();
                this.source.limit(currentLimit);
                this.source.position(currentPos);
            }
            this.slice.limit(this.end);
            this.slice.position(this.start);
            return this.slice;
        }

        @Override
        public void clearDirty() {
            this.regions.forEach(BufferRegion::clearDirty);
            super.clearDirty();
        }
    }
}

