/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.shader.bufferobject;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.renderer.Renderer;
import com.jme3.shader.bufferobject.BufferRegion;
import com.jme3.shader.bufferobject.DirtyRegionsIterator;
import com.jme3.util.BufferUtils;
import com.jme3.util.NativeObject;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class BufferObject
extends NativeObject
implements Savable {
    private AccessHint accessHint = AccessHint.Dynamic;
    private NatureHint natureHint = NatureHint.Draw;
    private transient WeakReference<BufferObject> weakRef;
    private transient int binding = -1;
    protected transient DirtyRegionsIterator dirtyRegionsIterator;
    protected ByteBuffer data = null;
    protected ArrayList<BufferRegion> regions = new ArrayList();
    private String name;

    public BufferObject() {
    }

    protected BufferObject(int id) {
        super(id);
    }

    @Override
    public final void setUpdateNeeded() {
        this.setUpdateNeeded(true);
    }

    public void setUpdateNeeded(boolean dirtyAll) {
        if (dirtyAll) {
            this.markAllRegionsDirty();
        }
        this.updateNeeded = true;
    }

    public int getBinding() {
        return this.binding;
    }

    public void initializeEmpty(int length) {
        if (this.data != null) {
            BufferUtils.destroyDirectBuffer(this.data);
        }
        this.data = BufferUtils.createByteBuffer(length);
    }

    public void setData(ByteBuffer data) {
        if (data != null) {
            BufferUtils.destroyDirectBuffer(data);
        }
        this.data = BufferUtils.createByteBuffer(data.limit() - data.position());
        this.data.put(data);
    }

    public ByteBuffer getData() {
        if (this.regions.size() == 0) {
            if (this.data == null) {
                this.data = BufferUtils.createByteBuffer(0);
            }
        } else {
            int regionsEnd = this.regions.get(this.regions.size() - 1).getEnd();
            if (this.data == null) {
                this.data = BufferUtils.createByteBuffer(regionsEnd + 1);
            } else if (this.data.limit() < regionsEnd) {
                ByteBuffer newData = BufferUtils.createByteBuffer(regionsEnd + 1);
                if (newData.limit() < this.data.limit()) {
                    this.data.limit(newData.limit());
                }
                newData.put(this.data);
                BufferUtils.destroyDirectBuffer(this.data);
                this.data = newData;
            }
        }
        this.data.rewind();
        return this.data;
    }

    public DirtyRegionsIterator getDirtyRegions() {
        if (this.dirtyRegionsIterator == null) {
            this.dirtyRegionsIterator = new DirtyRegionsIterator(this);
        }
        this.dirtyRegionsIterator.rewind();
        return this.dirtyRegionsIterator;
    }

    public void unsetRegions() {
        this.regions.clear();
        this.regions.trimToSize();
    }

    public void setRegions(List<BufferRegion> lr) {
        this.regions.clear();
        this.regions.addAll(lr);
        this.regions.trimToSize();
        this.setUpdateNeeded();
    }

    public BufferRegion getRegion(int i) {
        BufferRegion region = this.regions.get(i);
        region.bo = this;
        return region;
    }

    public void markAllRegionsDirty() {
        for (BufferRegion r : this.regions) {
            r.markDirty();
        }
    }

    @Override
    public void resetObject() {
        this.id = -1;
    }

    @Override
    protected void deleteNativeBuffers() {
        super.deleteNativeBuffers();
        if (this.data != null) {
            BufferUtils.destroyDirectBuffer(this.data);
        }
    }

    @Override
    public void deleteObject(Object rendererObject) {
        if (!(rendererObject instanceof Renderer)) {
            throw new IllegalArgumentException("This bo can't be deleted from " + rendererObject);
        }
        ((Renderer)rendererObject).deleteBuffer(this);
    }

    @Override
    public NativeObject createDestructableClone() {
        return new BufferObject(this.getId());
    }

    @Override
    public long getUniqueId() {
        return 0x900000000L | 0xFFFFFFFFL & (long)this.id;
    }

    public void setBinding(int binding) {
        this.binding = binding;
    }

    public WeakReference<BufferObject> getWeakRef() {
        if (this.weakRef == null) {
            this.weakRef = new WeakReference<BufferObject>(this);
        }
        return this.weakRef;
    }

    public AccessHint getAccessHint() {
        return this.accessHint;
    }

    public void setAccessHint(AccessHint accessHint) {
        this.accessHint = accessHint;
        this.setUpdateNeeded();
    }

    public NatureHint getNatureHint() {
        return this.natureHint;
    }

    public void setNatureHint(NatureHint natureHint) {
        this.natureHint = natureHint;
        this.setUpdateNeeded();
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.accessHint.ordinal(), "accessHint", 0);
        oc.write(this.natureHint.ordinal(), "natureHint", 0);
        oc.writeSavableArrayList(this.regions, "regions", null);
        oc.write(this.data, "data", null);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        InputCapsule ic = im.getCapsule(this);
        this.accessHint = AccessHint.values()[ic.readInt("accessHint", 0)];
        this.natureHint = NatureHint.values()[ic.readInt("natureHint", 0)];
        this.regions.addAll(ic.readSavableArrayList("regions", null));
        this.data = ic.readByteBuffer("data", null);
        this.setUpdateNeeded(true);
    }

    @Override
    public BufferObject clone() {
        BufferObject clone = (BufferObject)super.clone();
        clone.binding = -1;
        clone.weakRef = null;
        clone.data = BufferUtils.clone(this.data);
        clone.regions = new ArrayList();
        assert (clone.regions != this.regions);
        for (BufferRegion r : this.regions) {
            clone.regions.add(r.clone());
        }
        clone.dirtyRegionsIterator = null;
        clone.setUpdateNeeded();
        return clone;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("{\n");
        for (BufferRegion r : this.regions) {
            sb.append("    ").append(r).append("\n");
        }
        sb.append("}");
        return sb.toString();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static enum AccessHint {
        Static,
        Stream,
        Dynamic,
        CpuOnly;

    }

    public static enum NatureHint {
        Draw,
        Read,
        Copy;

    }
}

