/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.shape;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import java.io.IOException;

public class CenterQuad
extends Mesh {
    private float width;
    private float height;

    protected CenterQuad() {
    }

    public CenterQuad(float width, float height) {
        this.updateGeometry(width, height, false);
    }

    public CenterQuad(float width, float height, boolean flipCoords) {
        this.updateGeometry(width, height, flipCoords);
    }

    public float getHeight() {
        return this.height;
    }

    public float getWidth() {
        return this.width;
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        super.read(importer);
        InputCapsule capsule = importer.getCapsule(this);
        this.width = capsule.readFloat("width", 0.0f);
        this.height = capsule.readFloat("height", 0.0f);
    }

    @Override
    public void write(JmeExporter exporter) throws IOException {
        super.write(exporter);
        OutputCapsule capsule = exporter.getCapsule(this);
        capsule.write(this.width, "width", 0.0f);
        capsule.write(this.height, "height", 0.0f);
    }

    private void updateGeometry(float width, float height, boolean flipCoords) {
        this.width = width;
        this.height = height;
        float x = width / 2.0f;
        float y = height / 2.0f;
        this.setBuffer(VertexBuffer.Type.Position, 3, new float[]{-x, -y, 0.0f, x, -y, 0.0f, x, y, 0.0f, -x, y, 0.0f});
        if (flipCoords) {
            this.setBuffer(VertexBuffer.Type.TexCoord, 2, new float[]{0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f});
        } else {
            this.setBuffer(VertexBuffer.Type.TexCoord, 2, new float[]{0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f});
        }
        this.setBuffer(VertexBuffer.Type.Normal, 3, new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f});
        if (width * height < 0.0f) {
            this.setBuffer(VertexBuffer.Type.Index, 3, new byte[]{0, 2, 1, 0, 3, 2});
        } else {
            this.setBuffer(VertexBuffer.Type.Index, 3, new byte[]{0, 1, 2, 0, 2, 3});
        }
        this.updateBound();
        this.setStatic();
    }
}

