/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.mesh;

import com.jme3.scene.VertexBuffer;
import com.jme3.scene.mesh.IndexByteBuffer;
import com.jme3.scene.mesh.IndexIntBuffer;
import com.jme3.scene.mesh.IndexShortBuffer;
import com.jme3.util.BufferUtils;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;

public abstract class IndexBuffer {
    public static IndexBuffer wrapIndexBuffer(Buffer buf) {
        if (buf instanceof ByteBuffer) {
            return new IndexByteBuffer((ByteBuffer)buf);
        }
        if (buf instanceof ShortBuffer) {
            return new IndexShortBuffer((ShortBuffer)buf);
        }
        if (buf instanceof IntBuffer) {
            return new IndexIntBuffer((IntBuffer)buf);
        }
        throw new UnsupportedOperationException("Index buffer type unsupported: " + buf.getClass());
    }

    public static IndexBuffer createIndexBuffer(int vertexCount, int indexCount) {
        IndexBuffer result;
        if (vertexCount < 128) {
            ByteBuffer buffer = BufferUtils.createByteBuffer(indexCount);
            int maxIndexValue = Math.max(0, vertexCount - 1);
            result = new IndexByteBuffer(buffer, maxIndexValue);
        } else if (vertexCount < 65536) {
            ShortBuffer buffer = BufferUtils.createShortBuffer(indexCount);
            int maxIndexValue = vertexCount - 1;
            result = new IndexShortBuffer(buffer, maxIndexValue);
        } else {
            IntBuffer buffer = BufferUtils.createIntBuffer(indexCount);
            result = new IndexIntBuffer(buffer);
        }
        return result;
    }

    public void rewind() {
        this.getBuffer().rewind();
    }

    public int remaining() {
        return this.getBuffer().remaining();
    }

    public abstract int get();

    public abstract int get(int var1);

    public abstract IndexBuffer put(int var1, int var2);

    public abstract IndexBuffer put(int var1);

    public abstract int size();

    public abstract Buffer getBuffer();

    public abstract VertexBuffer.Format getFormat();
}

