/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene;

import com.jme3.math.Matrix4f;
import com.jme3.scene.BatchNode;
import com.jme3.scene.Geometry;
import com.jme3.scene.Spatial;
import com.jme3.util.TempVars;

public class SimpleBatchNode
extends BatchNode {
    private final Matrix4f cachedLocalMat = new Matrix4f();

    public SimpleBatchNode() {
    }

    public SimpleBatchNode(String name) {
        super(name);
    }

    @Override
    public int attachChild(Spatial child) {
        if (!(child instanceof Geometry)) {
            throw new UnsupportedOperationException("BatchNode is BatchMode.Simple only support child of type Geometry, use BatchMode.Complex to use a complex structure");
        }
        return super.attachChild(child);
    }

    @Override
    protected void setTransformRefresh() {
        this.refreshFlags |= 1;
        this.setBoundRefresh();
        for (BatchNode.Batch batch : (BatchNode.Batch[])this.batches.getArray()) {
            batch.geometry.setTransformRefresh();
        }
    }

    @Override
    protected Matrix4f getTransformMatrix(Geometry g) {
        this.cachedLocalMat.loadIdentity();
        this.cachedLocalMat.setRotationQuaternion(g.localTransform.getRotation());
        this.cachedLocalMat.setTranslation(g.localTransform.getTranslation());
        TempVars vars = TempVars.get();
        Matrix4f scaleMat = vars.tempMat4;
        scaleMat.loadIdentity();
        scaleMat.scale(g.localTransform.getScale());
        this.cachedLocalMat.multLocal(scaleMat);
        vars.release();
        return this.cachedLocalMat;
    }

    @Override
    public void batch() {
        this.doBatch();
    }
}

