/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene;

import com.jme3.bounding.BoundingBox;
import com.jme3.bounding.BoundingVolume;
import com.jme3.collision.Collidable;
import com.jme3.collision.CollisionResults;
import com.jme3.collision.bih.BIHTree;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Matrix4f;
import com.jme3.math.Triangle;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.CollisionData;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.mesh.IndexBuffer;
import com.jme3.scene.mesh.IndexIntBuffer;
import com.jme3.scene.mesh.IndexShortBuffer;
import com.jme3.scene.mesh.MorphTarget;
import com.jme3.scene.mesh.VirtualIndexBuffer;
import com.jme3.scene.mesh.WrappedIndexBuffer;
import com.jme3.util.BufferUtils;
import com.jme3.util.IntMap;
import com.jme3.util.SafeArrayList;
import com.jme3.util.clone.Cloner;
import com.jme3.util.clone.JmeCloneable;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;

public class Mesh
implements Savable,
Cloneable,
JmeCloneable {
    private static final int DEFAULT_VERTEX_ARRAY_ID = -1;
    private static final CollisionData DEFAULT_COLLISION_TREE = null;
    private static final float DEFAULT_POINT_SIZE = 1.0f;
    private static final float DEFAULT_LINE_WIDTH = 1.0f;
    private static final int DEFAULT_VERT_COUNT = -1;
    private static final int DEFAULT_ELEMENT_COUNT = -1;
    private static final int DEFAULT_INSTANCE_COUNT = -1;
    private static final int DEFAULT_PATCH_VERTEX_COUNT = 3;
    private static final int DEFAULT_MAX_NUM_WEIGHTS = -1;
    private BoundingVolume meshBound = new BoundingBox();
    private CollisionData collisionTree = DEFAULT_COLLISION_TREE;
    private SafeArrayList<VertexBuffer> buffersList = new SafeArrayList<VertexBuffer>(VertexBuffer.class);
    private IntMap<VertexBuffer> buffers = new IntMap();
    private VertexBuffer[] lodLevels;
    private float pointSize = 1.0f;
    private float lineWidth = 1.0f;
    private transient int vertexArrayID = -1;
    private int vertCount = -1;
    private int elementCount = -1;
    private int instanceCount = -1;
    private int patchVertexCount = 3;
    private int maxNumWeights = -1;
    private int[] elementLengths;
    private int[] modeStart;
    private Mode mode = Mode.Triangles;
    private SafeArrayList<MorphTarget> morphTargets;

    public Mesh clone() {
        try {
            Mesh clone = (Mesh)super.clone();
            clone.meshBound = this.meshBound.clone();
            clone.collisionTree = this.collisionTree != null ? this.collisionTree : null;
            clone.buffers = this.buffers.clone();
            clone.buffersList = new SafeArrayList<VertexBuffer>(VertexBuffer.class, this.buffersList);
            clone.vertexArrayID = -1;
            if (this.elementLengths != null) {
                clone.elementLengths = (int[])this.elementLengths.clone();
            }
            if (this.modeStart != null) {
                clone.modeStart = (int[])this.modeStart.clone();
            }
            return clone;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    public Mesh deepClone() {
        try {
            Mesh clone = (Mesh)super.clone();
            clone.meshBound = this.meshBound != null ? this.meshBound.clone() : null;
            clone.collisionTree = DEFAULT_COLLISION_TREE;
            clone.buffers = new IntMap();
            clone.buffersList = new SafeArrayList<VertexBuffer>(VertexBuffer.class);
            for (VertexBuffer vb : this.buffersList.getArray()) {
                VertexBuffer bufClone = vb.clone();
                clone.buffers.put(vb.getBufferType().ordinal(), bufClone);
                clone.buffersList.add(bufClone);
            }
            clone.vertexArrayID = -1;
            clone.vertCount = this.vertCount;
            clone.elementCount = this.elementCount;
            clone.instanceCount = this.instanceCount;
            clone.maxNumWeights = this.maxNumWeights;
            clone.elementLengths = this.elementLengths != null ? (int[])this.elementLengths.clone() : null;
            clone.modeStart = this.modeStart != null ? (int[])this.modeStart.clone() : null;
            return clone;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    public Mesh cloneForAnim() {
        Mesh clone = this.clone();
        if (this.getBuffer(VertexBuffer.Type.BindPosePosition) != null) {
            VertexBuffer oldPos = this.getBuffer(VertexBuffer.Type.Position);
            VertexBuffer newPos = oldPos.clone();
            clone.clearBuffer(VertexBuffer.Type.Position);
            clone.setBuffer(newPos);
            if (this.getBuffer(VertexBuffer.Type.BindPoseNormal) != null) {
                VertexBuffer oldNorm = this.getBuffer(VertexBuffer.Type.Normal);
                VertexBuffer newNorm = oldNorm.clone();
                clone.clearBuffer(VertexBuffer.Type.Normal);
                clone.setBuffer(newNorm);
                if (this.getBuffer(VertexBuffer.Type.BindPoseTangent) != null) {
                    VertexBuffer oldTang = this.getBuffer(VertexBuffer.Type.Tangent);
                    VertexBuffer newTang = oldTang.clone();
                    clone.clearBuffer(VertexBuffer.Type.Tangent);
                    clone.setBuffer(newTang);
                }
            }
        }
        return clone;
    }

    @Override
    public Mesh jmeClone() {
        try {
            Mesh clone = (Mesh)super.clone();
            clone.vertexArrayID = -1;
            return clone;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        this.collisionTree = DEFAULT_COLLISION_TREE;
        this.meshBound = cloner.clone(this.meshBound);
        this.buffersList = cloner.clone(this.buffersList);
        this.buffers = cloner.clone(this.buffers);
        this.lodLevels = cloner.clone(this.lodLevels);
        this.elementLengths = cloner.clone(this.elementLengths);
        this.modeStart = cloner.clone(this.modeStart);
    }

    @Deprecated
    public void generateBindPose(boolean forSoftwareAnim) {
        this.generateBindPose();
    }

    public void generateBindPose() {
        VertexBuffer tangents;
        VertexBuffer pos = this.getBuffer(VertexBuffer.Type.Position);
        if (pos == null || this.getBuffer(VertexBuffer.Type.BoneIndex) == null) {
            return;
        }
        VertexBuffer bindPos = new VertexBuffer(VertexBuffer.Type.BindPosePosition);
        bindPos.setupData(VertexBuffer.Usage.CpuOnly, pos.getNumComponents(), pos.getFormat(), BufferUtils.clone(pos.getData()));
        this.setBuffer(bindPos);
        pos.setUsage(VertexBuffer.Usage.Stream);
        VertexBuffer norm = this.getBuffer(VertexBuffer.Type.Normal);
        if (norm != null) {
            VertexBuffer bindNorm = new VertexBuffer(VertexBuffer.Type.BindPoseNormal);
            bindNorm.setupData(VertexBuffer.Usage.CpuOnly, norm.getNumComponents(), norm.getFormat(), BufferUtils.clone(norm.getData()));
            this.setBuffer(bindNorm);
            norm.setUsage(VertexBuffer.Usage.Stream);
        }
        if ((tangents = this.getBuffer(VertexBuffer.Type.Tangent)) != null) {
            VertexBuffer bindTangents = new VertexBuffer(VertexBuffer.Type.BindPoseTangent);
            bindTangents.setupData(VertexBuffer.Usage.CpuOnly, tangents.getNumComponents(), tangents.getFormat(), BufferUtils.clone(tangents.getData()));
            this.setBuffer(bindTangents);
            tangents.setUsage(VertexBuffer.Usage.Stream);
        }
    }

    public void prepareForAnim(boolean forSoftwareAnim) {
        if (forSoftwareAnim) {
            VertexBuffer indices = this.getBuffer(VertexBuffer.Type.BoneIndex);
            if (!indices.getData().hasArray()) {
                Buffer arrayIndex;
                Buffer originalIndex;
                if (indices.getFormat() == VertexBuffer.Format.UnsignedByte) {
                    originalIndex = (ByteBuffer)indices.getData();
                    arrayIndex = ByteBuffer.allocate(originalIndex.capacity());
                    ((ByteBuffer)originalIndex).clear();
                    ((ByteBuffer)arrayIndex).put((ByteBuffer)originalIndex);
                    indices.updateData(arrayIndex);
                } else {
                    originalIndex = (ShortBuffer)indices.getData();
                    arrayIndex = ShortBuffer.allocate(originalIndex.capacity());
                    ((ShortBuffer)originalIndex).clear();
                    ((ShortBuffer)arrayIndex).put((ShortBuffer)originalIndex);
                    indices.updateData(arrayIndex);
                }
            }
            indices.setUsage(VertexBuffer.Usage.CpuOnly);
            VertexBuffer weights = this.getBuffer(VertexBuffer.Type.BoneWeight);
            if (!weights.getData().hasArray()) {
                FloatBuffer originalWeight = (FloatBuffer)weights.getData();
                FloatBuffer arrayWeight = FloatBuffer.allocate(originalWeight.capacity());
                originalWeight.clear();
                arrayWeight.put(originalWeight);
                weights.updateData(arrayWeight);
            }
            weights.setUsage(VertexBuffer.Usage.CpuOnly);
            VertexBuffer positions = this.getBuffer(VertexBuffer.Type.Position);
            VertexBuffer normals = this.getBuffer(VertexBuffer.Type.Normal);
            VertexBuffer tangents = this.getBuffer(VertexBuffer.Type.Tangent);
            positions.setUsage(VertexBuffer.Usage.Stream);
            if (normals != null) {
                normals.setUsage(VertexBuffer.Usage.Stream);
            }
            if (tangents != null) {
                tangents.setUsage(VertexBuffer.Usage.Stream);
            }
        } else {
            VertexBuffer weightsHW;
            VertexBuffer indicesHW = this.getBuffer(VertexBuffer.Type.HWBoneIndex);
            if (indicesHW.getData() == null) {
                Buffer result;
                Buffer directIndex;
                Buffer originalIndex;
                VertexBuffer indices = this.getBuffer(VertexBuffer.Type.BoneIndex);
                if (indices.getFormat() == VertexBuffer.Format.UnsignedByte) {
                    originalIndex = (ByteBuffer)indices.getData();
                    directIndex = BufferUtils.createByteBuffer(originalIndex.capacity());
                    ((ByteBuffer)originalIndex).clear();
                    ((ByteBuffer)directIndex).put((ByteBuffer)originalIndex);
                    result = directIndex;
                } else {
                    originalIndex = (ShortBuffer)indices.getData();
                    directIndex = BufferUtils.createShortBuffer(originalIndex.capacity());
                    ((ShortBuffer)originalIndex).clear();
                    ((ShortBuffer)directIndex).put((ShortBuffer)originalIndex);
                    result = directIndex;
                }
                indicesHW.setupData(VertexBuffer.Usage.Static, indices.getNumComponents(), indices.getFormat(), result);
            }
            if ((weightsHW = this.getBuffer(VertexBuffer.Type.HWBoneWeight)).getData() == null) {
                VertexBuffer weights = this.getBuffer(VertexBuffer.Type.BoneWeight);
                FloatBuffer originalWeight = (FloatBuffer)weights.getData();
                FloatBuffer directWeight = BufferUtils.createFloatBuffer(originalWeight.capacity());
                originalWeight.clear();
                directWeight.put(originalWeight);
                weightsHW.setupData(VertexBuffer.Usage.Static, weights.getNumComponents(), weights.getFormat(), directWeight);
            }
            VertexBuffer positions = this.getBuffer(VertexBuffer.Type.Position);
            VertexBuffer normals = this.getBuffer(VertexBuffer.Type.Normal);
            VertexBuffer tangents = this.getBuffer(VertexBuffer.Type.Tangent);
            VertexBuffer positionsBP = this.getBuffer(VertexBuffer.Type.BindPosePosition);
            VertexBuffer normalsBP = this.getBuffer(VertexBuffer.Type.BindPoseNormal);
            VertexBuffer tangentsBP = this.getBuffer(VertexBuffer.Type.BindPoseTangent);
            positions.setUsage(VertexBuffer.Usage.Static);
            positionsBP.copyElements(0, positions, 0, positionsBP.getNumElements());
            positions.setUpdateNeeded();
            if (normals != null) {
                normals.setUsage(VertexBuffer.Usage.Static);
                normalsBP.copyElements(0, normals, 0, normalsBP.getNumElements());
                normals.setUpdateNeeded();
            }
            if (tangents != null) {
                tangents.setUsage(VertexBuffer.Usage.Static);
                tangentsBP.copyElements(0, tangents, 0, tangentsBP.getNumElements());
                tangents.setUpdateNeeded();
            }
        }
    }

    public void setLodLevels(VertexBuffer[] lodLevels) {
        this.lodLevels = lodLevels;
    }

    public int getNumLodLevels() {
        return this.lodLevels != null ? this.lodLevels.length : 0;
    }

    public VertexBuffer getLodLevel(int lod) {
        return this.lodLevels[lod];
    }

    public int[] getElementLengths() {
        return this.elementLengths;
    }

    public void setElementLengths(int[] elementLengths) {
        this.elementLengths = elementLengths;
    }

    public int[] getModeStart() {
        return this.modeStart;
    }

    public void setModeStart(int[] modeStart) {
        this.modeStart = modeStart;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
        this.updateCounts();
    }

    public int getMaxNumWeights() {
        return this.maxNumWeights;
    }

    public void setMaxNumWeights(int maxNumWeights) {
        this.maxNumWeights = maxNumWeights;
    }

    @Deprecated
    public float getPointSize() {
        return 1.0f;
    }

    @Deprecated
    public float getLineWidth() {
        return this.lineWidth;
    }

    @Deprecated
    public void setLineWidth(float lineWidth) {
        if (lineWidth < 1.0f) {
            throw new IllegalArgumentException("lineWidth must be greater than or equal to 1.0");
        }
        this.lineWidth = lineWidth;
    }

    public void setStatic() {
        for (VertexBuffer vb : this.buffersList.getArray()) {
            vb.setUsage(VertexBuffer.Usage.Static);
        }
    }

    public void setDynamic() {
        for (VertexBuffer vb : this.buffersList.getArray()) {
            vb.setUsage(VertexBuffer.Usage.Dynamic);
        }
    }

    public void setStreamed() {
        for (VertexBuffer vb : this.buffersList.getArray()) {
            vb.setUsage(VertexBuffer.Usage.Stream);
        }
    }

    @Deprecated
    public void setInterleaved() {
        ArrayList<VertexBuffer> vbs = new ArrayList<VertexBuffer>();
        vbs.addAll(this.buffersList);
        vbs.remove(this.getBuffer(VertexBuffer.Type.Index));
        int stride = 0;
        for (int i = 0; i < vbs.size(); ++i) {
            VertexBuffer vb = (VertexBuffer)vbs.get(i);
            stride += vb.componentsLength;
            vb.getData().clear();
        }
        VertexBuffer allData = new VertexBuffer(VertexBuffer.Type.InterleavedData);
        ByteBuffer dataBuf = BufferUtils.createByteBuffer(stride * this.getVertexCount());
        allData.setupData(VertexBuffer.Usage.Static, 1, VertexBuffer.Format.UnsignedByte, dataBuf);
        this.buffers.put(VertexBuffer.Type.InterleavedData.ordinal(), allData);
        this.buffersList.add(allData);
        for (int vert = 0; vert < this.getVertexCount(); ++vert) {
            block9: for (int i = 0; i < vbs.size(); ++i) {
                VertexBuffer vb = (VertexBuffer)vbs.get(i);
                switch (vb.getFormat()) {
                    case Float: {
                        FloatBuffer fb = (FloatBuffer)vb.getData();
                        for (int comp = 0; comp < vb.components; ++comp) {
                            dataBuf.putFloat(fb.get());
                        }
                        continue block9;
                    }
                    case Byte: 
                    case UnsignedByte: {
                        ByteBuffer bb = (ByteBuffer)vb.getData();
                        for (int comp = 0; comp < vb.components; ++comp) {
                            dataBuf.put(bb.get());
                        }
                        continue block9;
                    }
                    case Half: 
                    case Short: 
                    case UnsignedShort: {
                        ShortBuffer sb = (ShortBuffer)vb.getData();
                        for (int comp = 0; comp < vb.components; ++comp) {
                            dataBuf.putShort(sb.get());
                        }
                        continue block9;
                    }
                    case Int: 
                    case UnsignedInt: {
                        IntBuffer ib = (IntBuffer)vb.getData();
                        for (int comp = 0; comp < vb.components; ++comp) {
                            dataBuf.putInt(ib.get());
                        }
                        continue block9;
                    }
                    case Double: {
                        DoubleBuffer db = (DoubleBuffer)vb.getData();
                        for (int comp = 0; comp < vb.components; ++comp) {
                            dataBuf.putDouble(db.get());
                        }
                        continue block9;
                    }
                }
            }
        }
        int offset = 0;
        for (VertexBuffer vb : vbs) {
            vb.setOffset(offset);
            vb.setStride(stride);
            vb.updateData(null);
            offset += vb.componentsLength;
        }
    }

    private int computeNumElements(int bufSize) {
        switch (this.mode) {
            case Triangles: {
                return bufSize / 3;
            }
            case TriangleFan: 
            case TriangleStrip: {
                return bufSize - 2;
            }
            case Points: {
                return bufSize;
            }
            case Lines: {
                return bufSize / 2;
            }
            case LineLoop: {
                return bufSize;
            }
            case LineStrip: {
                return bufSize - 1;
            }
            case Patch: {
                return bufSize / this.patchVertexCount;
            }
        }
        throw new UnsupportedOperationException();
    }

    private int computeInstanceCount() {
        int max = 0;
        for (VertexBuffer vb : this.buffersList) {
            if (vb.getBaseInstanceCount() <= max) continue;
            max = vb.getBaseInstanceCount();
        }
        return max;
    }

    public void updateCounts() {
        if (this.getBuffer(VertexBuffer.Type.InterleavedData) != null) {
            throw new IllegalStateException("Should update counts before interleave");
        }
        VertexBuffer pb = this.getBuffer(VertexBuffer.Type.Position);
        VertexBuffer ib = this.getBuffer(VertexBuffer.Type.Index);
        if (pb != null) {
            this.vertCount = pb.getData().limit() / pb.getNumComponents();
        }
        this.elementCount = ib != null ? this.computeNumElements(ib.getData().limit()) : this.computeNumElements(this.vertCount);
        this.instanceCount = this.computeInstanceCount();
    }

    public int getTriangleCount(int lod) {
        if (this.lodLevels != null) {
            if (lod < 0) {
                throw new IllegalArgumentException("LOD level cannot be < 0");
            }
            if (lod >= this.lodLevels.length) {
                throw new IllegalArgumentException("LOD level " + lod + " does not exist!");
            }
            return this.computeNumElements(this.lodLevels[lod].getData().limit());
        }
        if (lod == 0) {
            return this.elementCount;
        }
        throw new IllegalArgumentException("There are no LOD levels on the mesh!");
    }

    public int getTriangleCount() {
        return this.elementCount;
    }

    public int getVertexCount() {
        return this.vertCount;
    }

    public int getInstanceCount() {
        return this.instanceCount;
    }

    public void getTriangle(int index, Vector3f v1, Vector3f v2, Vector3f v3) {
        VertexBuffer pb = this.getBuffer(VertexBuffer.Type.Position);
        IndexBuffer ib = this.getIndicesAsList();
        if (pb == null || pb.getFormat() != VertexBuffer.Format.Float || pb.getNumComponents() != 3) {
            throw new UnsupportedOperationException("Position buffer not set or  has incompatible format");
        }
        FloatBuffer fpb = (FloatBuffer)pb.getData();
        int vertIndex = index * 3;
        int vert1 = ib.get(vertIndex);
        int vert2 = ib.get(vertIndex + 1);
        int vert3 = ib.get(vertIndex + 2);
        BufferUtils.populateFromBuffer(v1, fpb, vert1);
        BufferUtils.populateFromBuffer(v2, fpb, vert2);
        BufferUtils.populateFromBuffer(v3, fpb, vert3);
    }

    public void getTriangle(int index, Triangle tri) {
        this.getTriangle(index, tri.get1(), tri.get2(), tri.get3());
        tri.setIndex(index);
        tri.setCenter(null);
        tri.setNormal(null);
    }

    public void getTriangle(int index, int[] indices) {
        IndexBuffer ib = this.getIndicesAsList();
        int vertIndex = index * 3;
        indices[0] = ib.get(vertIndex);
        indices[1] = ib.get(vertIndex + 1);
        indices[2] = ib.get(vertIndex + 2);
    }

    public int getId() {
        return this.vertexArrayID;
    }

    public void setId(int id) {
        if (this.vertexArrayID != -1) {
            throw new IllegalStateException("ID has already been set.");
        }
        this.vertexArrayID = id;
    }

    public void createCollisionData() {
        BIHTree tree = new BIHTree(this);
        tree.construct();
        this.collisionTree = tree;
    }

    public void clearCollisionData() {
        this.collisionTree = DEFAULT_COLLISION_TREE;
    }

    public int collideWith(Collidable other, Matrix4f worldMatrix, BoundingVolume worldBound, CollisionResults results) {
        switch (this.mode) {
            case Points: 
            case Lines: 
            case LineLoop: 
            case LineStrip: {
                return 0;
            }
        }
        if (this.getVertexCount() == 0) {
            return 0;
        }
        if (this.collisionTree == null) {
            this.createCollisionData();
        }
        return this.collisionTree.collideWith(other, worldMatrix, worldBound, results);
    }

    public void setBuffer(VertexBuffer vb) {
        if (this.buffers.containsKey(vb.getBufferType().ordinal())) {
            throw new IllegalArgumentException("Buffer type already set: " + (Object)((Object)vb.getBufferType()));
        }
        this.buffers.put(vb.getBufferType().ordinal(), vb);
        this.buffersList.add(vb);
        this.updateCounts();
    }

    public void clearBuffer(VertexBuffer.Type type) {
        VertexBuffer vb = this.buffers.remove(type.ordinal());
        if (vb != null) {
            this.buffersList.remove(vb);
            this.updateCounts();
        }
    }

    public void setBuffer(VertexBuffer.Type type, int components, VertexBuffer.Format format, Buffer buf) {
        VertexBuffer vb = this.buffers.get(type.ordinal());
        if (vb == null) {
            vb = new VertexBuffer(type);
            vb.setupData(VertexBuffer.Usage.Dynamic, components, format, buf);
            this.setBuffer(vb);
        } else {
            if (vb.getNumComponents() != components || vb.getFormat() != format) {
                throw new UnsupportedOperationException("The buffer already set is incompatible with the given parameters");
            }
            vb.updateData(buf);
            this.updateCounts();
        }
    }

    public void setBuffer(VertexBuffer.Type type, int components, FloatBuffer buf) {
        this.setBuffer(type, components, VertexBuffer.Format.Float, buf);
    }

    public void setBuffer(VertexBuffer.Type type, int components, float[] buf) {
        this.setBuffer(type, components, BufferUtils.createFloatBuffer(buf));
    }

    public void setBuffer(VertexBuffer.Type type, int components, IntBuffer buf) {
        this.setBuffer(type, components, VertexBuffer.Format.UnsignedInt, buf);
    }

    public void setBuffer(VertexBuffer.Type type, int components, int[] buf) {
        this.setBuffer(type, components, BufferUtils.createIntBuffer(buf));
    }

    public void setBuffer(VertexBuffer.Type type, int components, ShortBuffer buf) {
        this.setBuffer(type, components, VertexBuffer.Format.UnsignedShort, buf);
    }

    public void setBuffer(VertexBuffer.Type type, int components, byte[] buf) {
        this.setBuffer(type, components, BufferUtils.createByteBuffer(buf));
    }

    public void setBuffer(VertexBuffer.Type type, int components, ByteBuffer buf) {
        this.setBuffer(type, components, VertexBuffer.Format.UnsignedByte, buf);
    }

    public void setBuffer(VertexBuffer.Type type, int components, short[] buf) {
        this.setBuffer(type, components, BufferUtils.createShortBuffer(buf));
    }

    public VertexBuffer getBuffer(VertexBuffer.Type type) {
        return this.buffers.get(type.ordinal());
    }

    public FloatBuffer getFloatBuffer(VertexBuffer.Type type) {
        VertexBuffer vb = this.getBuffer(type);
        if (vb == null) {
            return null;
        }
        return (FloatBuffer)vb.getData();
    }

    public ShortBuffer getShortBuffer(VertexBuffer.Type type) {
        VertexBuffer vb = this.getBuffer(type);
        if (vb == null) {
            return null;
        }
        return (ShortBuffer)vb.getData();
    }

    public IndexBuffer getIndicesAsList() {
        if (this.mode == Mode.Hybrid) {
            throw new UnsupportedOperationException("Hybrid mode not supported");
        }
        IndexBuffer ib = this.getIndexBuffer();
        if (ib != null) {
            if (this.mode.isListMode()) {
                return ib;
            }
            return new WrappedIndexBuffer(this);
        }
        return new VirtualIndexBuffer(this.vertCount, this.mode);
    }

    public IndexBuffer getIndexBuffer() {
        VertexBuffer vb = this.getBuffer(VertexBuffer.Type.Index);
        if (vb == null) {
            return null;
        }
        return IndexBuffer.wrapIndexBuffer(vb.getData());
    }

    public void extractVertexData(Mesh other) {
        VertexBuffer oldIdxBuf = this.getBuffer(VertexBuffer.Type.Index);
        IndexBuffer indexBuf = this.getIndexBuffer();
        int numIndices = indexBuf.size();
        IntMap<Integer> oldIndicesToNewIndices = new IntMap<Integer>(numIndices);
        ArrayList<Integer> newIndicesToOldIndices = new ArrayList<Integer>();
        int newIndex = 0;
        for (int i = 0; i < numIndices; ++i) {
            int oldIndex = indexBuf.get(i);
            if (oldIndicesToNewIndices.containsKey(oldIndex)) continue;
            oldIndicesToNewIndices.put(oldIndex, newIndex);
            newIndicesToOldIndices.add(oldIndex);
            ++newIndex;
        }
        int newNumVerts = newIndicesToOldIndices.size();
        if (newIndex != newNumVerts) {
            throw new AssertionError();
        }
        IndexBuffer newIndexBuf = newNumVerts >= 65536 ? new IndexIntBuffer(BufferUtils.createIntBuffer(numIndices)) : new IndexShortBuffer(BufferUtils.createShortBuffer(numIndices));
        for (int i = 0; i < numIndices; ++i) {
            int oldIndex = indexBuf.get(i);
            newIndex = (Integer)oldIndicesToNewIndices.get(oldIndex);
            newIndexBuf.put(i, newIndex);
        }
        VertexBuffer newIdxBuf = new VertexBuffer(VertexBuffer.Type.Index);
        newIdxBuf.setupData(oldIdxBuf.getUsage(), oldIdxBuf.getNumComponents(), newIndexBuf instanceof IndexIntBuffer ? VertexBuffer.Format.UnsignedInt : VertexBuffer.Format.UnsignedShort, newIndexBuf.getBuffer());
        this.clearBuffer(VertexBuffer.Type.Index);
        this.setBuffer(newIdxBuf);
        SafeArrayList<VertexBuffer> oldVertexData = other.getBufferList();
        for (VertexBuffer oldVb : oldVertexData) {
            if (oldVb.getBufferType() == VertexBuffer.Type.Index) continue;
            VertexBuffer newVb = new VertexBuffer(oldVb.getBufferType());
            newVb.setNormalized(oldVb.isNormalized());
            if (oldVb.getData() != null) {
                Buffer buffer = VertexBuffer.createBuffer(oldVb.getFormat(), oldVb.getNumComponents(), newNumVerts);
                newVb.setupData(oldVb.getUsage(), oldVb.getNumComponents(), oldVb.getFormat(), buffer);
                for (int i = 0; i < newNumVerts; ++i) {
                    int oldIndex = (Integer)newIndicesToOldIndices.get(i);
                    oldVb.copyElement(oldIndex, newVb, i);
                }
            }
            this.clearBuffer(newVb.getBufferType());
            this.setBuffer(newVb);
        }
        this.setMaxNumWeights(other.getMaxNumWeights());
        this.updateCounts();
        this.updateBound();
    }

    public void scaleTextureCoordinates(Vector2f scaleFactor) {
        VertexBuffer tc = this.getBuffer(VertexBuffer.Type.TexCoord);
        if (tc == null) {
            throw new IllegalStateException("The mesh has no texture coordinates");
        }
        if (tc.getFormat() != VertexBuffer.Format.Float) {
            throw new UnsupportedOperationException("Only float texture coord format is supported");
        }
        if (tc.getNumComponents() != 2) {
            throw new UnsupportedOperationException("Only 2D texture coords are supported");
        }
        FloatBuffer fb = (FloatBuffer)tc.getData();
        fb.clear();
        for (int i = 0; i < fb.limit() / 2; ++i) {
            float x = fb.get();
            float y = fb.get();
            fb.position(fb.position() - 2);
            fb.put(x *= scaleFactor.getX()).put(y *= scaleFactor.getY());
        }
        fb.clear();
        tc.updateData(fb);
    }

    public void updateBound() {
        VertexBuffer posBuf = this.getBuffer(VertexBuffer.Type.Position);
        if (this.meshBound != null && posBuf != null) {
            this.meshBound.computeFromPoints((FloatBuffer)posBuf.getData());
        }
    }

    public BoundingVolume getBound() {
        return this.meshBound;
    }

    public void setBound(BoundingVolume modelBound) {
        this.meshBound = modelBound;
    }

    public IntMap<VertexBuffer> getBuffers() {
        return this.buffers;
    }

    public SafeArrayList<VertexBuffer> getBufferList() {
        return this.buffersList;
    }

    public boolean isAnimated() {
        return this.getBuffer(VertexBuffer.Type.BoneIndex) != null || this.getBuffer(VertexBuffer.Type.HWBoneIndex) != null;
    }

    @Deprecated
    public boolean isAnimatedByBone(int boneIndex) {
        return this.isAnimatedByJoint(boneIndex);
    }

    public boolean isAnimatedByJoint(int jointIndex) {
        VertexBuffer biBuf = this.getBuffer(VertexBuffer.Type.BoneIndex);
        VertexBuffer wBuf = this.getBuffer(VertexBuffer.Type.BoneWeight);
        if (biBuf == null || wBuf == null) {
            return false;
        }
        IndexBuffer boneIndexBuffer = IndexBuffer.wrapIndexBuffer(biBuf.getData());
        boneIndexBuffer.rewind();
        int numBoneIndices = boneIndexBuffer.remaining();
        assert (numBoneIndices % 4 == 0) : numBoneIndices;
        int numVertices = boneIndexBuffer.remaining() / 4;
        FloatBuffer weightBuffer = (FloatBuffer)wBuf.getData();
        weightBuffer.rewind();
        int numWeights = weightBuffer.remaining();
        assert (numWeights == numVertices * 4) : numWeights;
        int biByte = jointIndex;
        for (int vIndex = 0; vIndex < numVertices; ++vIndex) {
            for (int wIndex = 0; wIndex < 4; ++wIndex) {
                int bIndex = boneIndexBuffer.get();
                float weight = weightBuffer.get();
                if (wIndex >= this.maxNumWeights || bIndex != biByte || weight == 0.0f) continue;
                return true;
            }
        }
        return false;
    }

    public void setPatchVertexCount(int patchVertexCount) {
        this.patchVertexCount = patchVertexCount;
    }

    public int getPatchVertexCount() {
        return this.patchVertexCount;
    }

    public void addMorphTarget(MorphTarget target) {
        if (this.morphTargets == null) {
            this.morphTargets = new SafeArrayList<MorphTarget>(MorphTarget.class);
        }
        this.morphTargets.add(target);
    }

    public boolean removeMorphTarget(MorphTarget target) {
        return this.morphTargets != null ? this.morphTargets.remove(target) : false;
    }

    public MorphTarget removeMorphTarget(int index) {
        if (this.morphTargets == null) {
            throw new IndexOutOfBoundsException("Index:" + index + ", Size:0");
        }
        return this.morphTargets.remove(index);
    }

    public MorphTarget getMorphTarget(int index) {
        if (this.morphTargets == null) {
            throw new IndexOutOfBoundsException("Index:" + index + ", Size:0");
        }
        return this.morphTargets.get(index);
    }

    public MorphTarget[] getMorphTargets() {
        if (this.morphTargets == null) {
            return new MorphTarget[0];
        }
        return this.morphTargets.getArray();
    }

    public String[] getMorphTargetNames() {
        MorphTarget[] nbMorphTargets = this.getMorphTargets();
        if (nbMorphTargets.length == 0) {
            return new String[0];
        }
        String[] targets = new String[nbMorphTargets.length];
        for (int index = 0; index < nbMorphTargets.length; ++index) {
            targets[index] = nbMorphTargets[index].getName();
        }
        return targets;
    }

    public boolean hasMorphTargets() {
        return this.morphTargets != null && !this.morphTargets.isEmpty();
    }

    public int getMorphIndex(String morphName) {
        int index = -1;
        MorphTarget[] nbMorphTargets = this.getMorphTargets();
        for (int i = 0; i < nbMorphTargets.length; ++i) {
            if (!nbMorphTargets[i].getName().equals(morphName)) continue;
            index = i;
            break;
        }
        return index;
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        OutputCapsule out = ex.getCapsule(this);
        out.write(this.meshBound, "modelBound", null);
        out.write(this.vertCount, "vertCount", -1);
        out.write(this.elementCount, "elementCount", -1);
        out.write(this.instanceCount, "instanceCount", -1);
        out.write(this.maxNumWeights, "max_num_weights", -1);
        out.write(this.mode, "mode", Mode.Triangles);
        out.write(this.collisionTree, "collisionTree", DEFAULT_COLLISION_TREE);
        out.write(this.elementLengths, "elementLengths", (int[])null);
        out.write(this.modeStart, "modeStart", (int[])null);
        out.write(this.pointSize, "pointSize", 1.0f);
        VertexBuffer hwBoneIndex = null;
        VertexBuffer hwBoneWeight = null;
        hwBoneIndex = this.getBuffer(VertexBuffer.Type.HWBoneIndex);
        if (hwBoneIndex != null) {
            this.buffers.remove(VertexBuffer.Type.HWBoneIndex.ordinal());
        }
        if ((hwBoneWeight = this.getBuffer(VertexBuffer.Type.HWBoneWeight)) != null) {
            this.buffers.remove(VertexBuffer.Type.HWBoneWeight.ordinal());
        }
        out.writeIntSavableMap(this.buffers, "buffers", null);
        if (hwBoneIndex != null) {
            this.buffers.put(hwBoneIndex.getBufferType().ordinal(), hwBoneIndex);
        }
        if (hwBoneWeight != null) {
            this.buffers.put(hwBoneWeight.getBufferType().ordinal(), hwBoneWeight);
        }
        out.write(this.lodLevels, "lodLevels", null);
        if (this.morphTargets != null) {
            out.writeSavableArrayList(new ArrayList<MorphTarget>(this.morphTargets), "morphTargets", null);
        }
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        ArrayList arrayList;
        Savable[] lodLevelsSavable;
        InputCapsule in = im.getCapsule(this);
        this.meshBound = (BoundingVolume)in.readSavable("modelBound", null);
        this.vertCount = in.readInt("vertCount", -1);
        this.elementCount = in.readInt("elementCount", -1);
        this.instanceCount = in.readInt("instanceCount", -1);
        this.maxNumWeights = in.readInt("max_num_weights", -1);
        this.mode = in.readEnum("mode", Mode.class, Mode.Triangles);
        this.elementLengths = in.readIntArray("elementLengths", null);
        this.modeStart = in.readIntArray("modeStart", null);
        this.collisionTree = (BIHTree)in.readSavable("collisionTree", DEFAULT_COLLISION_TREE);
        this.elementLengths = in.readIntArray("elementLengths", null);
        this.modeStart = in.readIntArray("modeStart", null);
        this.pointSize = in.readFloat("pointSize", 1.0f);
        this.buffers = in.readIntSavableMap("buffers", null);
        for (IntMap.Entry<VertexBuffer> entry : this.buffers) {
            this.buffersList.add(entry.getValue());
        }
        if (this.isAnimated()) {
            VertexBuffer hwBoneIndex = new VertexBuffer(VertexBuffer.Type.HWBoneIndex);
            hwBoneIndex.setUsage(VertexBuffer.Usage.CpuOnly);
            this.setBuffer(hwBoneIndex);
            VertexBuffer vertexBuffer = new VertexBuffer(VertexBuffer.Type.HWBoneWeight);
            vertexBuffer.setUsage(VertexBuffer.Usage.CpuOnly);
            this.setBuffer(vertexBuffer);
        }
        if ((lodLevelsSavable = in.readSavableArray("lodLevels", null)) != null) {
            this.lodLevels = new VertexBuffer[lodLevelsSavable.length];
            System.arraycopy(lodLevelsSavable, 0, this.lodLevels, 0, this.lodLevels.length);
        }
        if ((arrayList = in.readSavableArrayList("morphTargets", null)) != null) {
            this.morphTargets = new SafeArrayList<MorphTarget>(MorphTarget.class, arrayList);
        }
    }

    public static enum Mode {
        Points(true),
        Lines(true),
        LineStrip(false),
        LineLoop(false),
        Triangles(true),
        TriangleStrip(false),
        TriangleFan(false),
        Hybrid(false),
        Patch(true);

        private boolean listMode = false;

        private Mode(boolean listMode) {
            this.listMode = listMode;
        }

        public boolean isListMode() {
            return this.listMode;
        }
    }
}

