/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.material.plugins;

import com.jme3.asset.AssetManager;
import com.jme3.asset.AssetNotFoundException;
import com.jme3.asset.ShaderNodeDefinitionKey;
import com.jme3.material.MatParam;
import com.jme3.material.MaterialDef;
import com.jme3.material.ShaderGenerationInfo;
import com.jme3.material.TechniqueDef;
import com.jme3.material.plugins.ConditionParser;
import com.jme3.material.plugins.MatParseException;
import com.jme3.shader.Shader;
import com.jme3.shader.ShaderNode;
import com.jme3.shader.ShaderNodeDefinition;
import com.jme3.shader.ShaderNodeVariable;
import com.jme3.shader.ShaderUtils;
import com.jme3.shader.UniformBinding;
import com.jme3.shader.VarType;
import com.jme3.shader.VariableMapping;
import com.jme3.util.blockparser.Statement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ShaderNodeLoaderDelegate {
    private static final boolean[] IM_HAS_NAME_SPACE = new boolean[]{false, true};
    private static final boolean[] OM_HAS_NAME_SPACE = new boolean[]{true, false};
    protected Map<String, ShaderNodeDefinition> nodeDefinitions;
    protected Map<String, ShaderNode> nodes;
    protected ShaderNodeDefinition shaderNodeDefinition;
    protected ShaderNode shaderNode;
    protected TechniqueDef techniqueDef;
    protected Map<String, DeclaredVariable> attributes = new HashMap<String, DeclaredVariable>();
    protected Map<String, DeclaredVariable> vertexDeclaredUniforms = new HashMap<String, DeclaredVariable>();
    protected Map<String, DeclaredVariable> fragmentDeclaredUniforms = new HashMap<String, DeclaredVariable>();
    protected Map<String, DeclaredVariable> varyings = new HashMap<String, DeclaredVariable>();
    protected MaterialDef materialDef;
    protected String shaderLanguage;
    protected String shaderName;
    protected Set<String> varNames = new HashSet<String>();
    protected AssetManager assetManager;
    protected ConditionParser conditionParser = new ConditionParser();
    protected List<String> nulledConditions = new ArrayList<String>();

    public List<ShaderNodeDefinition> readNodesDefinitions(List<Statement> statements, ShaderNodeDefinitionKey key) throws IOException {
        for (Statement statement : statements) {
            String[] split = statement.getLine().split("[ \\{]");
            if (statement.getLine().startsWith("ShaderNodeDefinition")) {
                String name = statement.getLine().substring("ShaderNodeDefinition".length()).trim();
                if (this.getNodeDefinitions().containsKey(name)) continue;
                this.shaderNodeDefinition = new ShaderNodeDefinition();
                this.getNodeDefinitions().put(name, this.shaderNodeDefinition);
                this.shaderNodeDefinition.setName(name);
                this.shaderNodeDefinition.setPath(key.getName());
                this.readShaderNodeDefinition(statement.getContents(), key);
                continue;
            }
            throw new MatParseException("ShaderNodeDefinition", split[0], statement);
        }
        return new ArrayList<ShaderNodeDefinition>(this.getNodeDefinitions().values());
    }

    public void readNodesDefinitions(List<Statement> statements) throws IOException {
        this.readNodesDefinitions(statements, new ShaderNodeDefinitionKey());
    }

    protected void readShaderNodeDefinition(List<Statement> statements, ShaderNodeDefinitionKey key) throws IOException {
        boolean isLoadDoc = key instanceof ShaderNodeDefinitionKey && key.isLoadDocumentation();
        for (Statement statement : statements) {
            try {
                String[] split = statement.getLine().split("[ \\{]");
                String line = statement.getLine();
                if (line.startsWith("Type")) {
                    String type = line.substring(line.lastIndexOf(58) + 1).trim();
                    this.shaderNodeDefinition.setType(Shader.ShaderType.valueOf(type));
                    continue;
                }
                if (line.startsWith("Shader ")) {
                    this.readShaderStatement(statement);
                    this.shaderNodeDefinition.getShadersLanguage().add(this.shaderLanguage);
                    this.shaderNodeDefinition.getShadersPath().add(this.shaderName);
                    continue;
                }
                if (line.startsWith("Documentation")) {
                    if (!isLoadDoc) continue;
                    String doc = "";
                    for (Statement statement1 : statement.getContents()) {
                        doc = doc + "\n" + statement1.getLine();
                    }
                    this.shaderNodeDefinition.setDocumentation(doc);
                    continue;
                }
                if (line.startsWith("Input")) {
                    this.varNames.clear();
                    for (Statement statement1 : statement.getContents()) {
                        try {
                            this.shaderNodeDefinition.getInputs().add(this.readVariable(statement1));
                        }
                        catch (RuntimeException e) {
                            throw new MatParseException(e.getMessage(), statement1, e);
                        }
                    }
                    continue;
                }
                if (line.startsWith("Output")) {
                    this.varNames.clear();
                    for (Statement statement1 : statement.getContents()) {
                        try {
                            if (statement1.getLine().trim().equals("None")) {
                                this.shaderNodeDefinition.setNoOutput(true);
                                continue;
                            }
                            this.shaderNodeDefinition.getOutputs().add(this.readVariable(statement1));
                        }
                        catch (RuntimeException e) {
                            throw new MatParseException(e.getMessage(), statement1, e);
                        }
                    }
                    continue;
                }
                throw new MatParseException("one of Type, Shader, Documentation, Input, Output", split[0], statement);
            }
            catch (RuntimeException e) {
                throw new MatParseException(e.getMessage(), statement, e);
            }
        }
    }

    protected ShaderNodeVariable readVariable(Statement statement) throws IOException {
        String line = statement.getLine().trim().replaceAll("\\s*\\[", "[");
        String[] splitVar = line.split("\\s");
        if (splitVar.length > 3) {
            throw new MatParseException("More than 3 arguments", splitVar.length + "", statement);
        }
        String defaultValue = splitVar.length > 2 ? splitVar[2] : null;
        String varName = splitVar[1];
        String varType = splitVar[0];
        String multiplicity = null;
        if (varName.contains("[")) {
            String[] arr = splitVar[1].split("\\[");
            varName = arr[0].trim();
            multiplicity = arr[1].replaceAll("\\]", "").trim();
        }
        if (this.varNames.contains(varName)) {
            throw new MatParseException("Duplicate variable name " + varName, statement);
        }
        this.varNames.add(varName);
        ShaderNodeVariable variable = new ShaderNodeVariable(varType, "", varName, multiplicity);
        variable.setDefaultValue(defaultValue);
        return variable;
    }

    public void readVertexShaderNodes(List<Statement> statements) throws IOException {
        this.attributes.clear();
        this.readNodes(statements);
    }

    protected void readShaderNode(List<Statement> statements) throws IOException {
        ShaderGenerationInfo generationInfo = this.techniqueDef.getShaderGenerationInfo();
        List<String> unusedNodes = generationInfo.getUnusedNodes();
        for (Statement statement : statements) {
            VariableMapping mapping;
            String line = statement.getLine();
            String[] split = statement.getLine().split("[ \\{]");
            if (line.startsWith("Definition")) {
                ShaderNodeDefinition def = this.findDefinition(statement);
                this.shaderNode.setDefinition(def);
                if (!def.isNoOutput()) continue;
                unusedNodes.remove(this.shaderNode.getName());
                continue;
            }
            if (line.startsWith("Condition")) {
                String condition = line.substring(line.lastIndexOf(":") + 1).trim();
                this.extractCondition(condition, statement);
                this.shaderNode.setCondition(this.conditionParser.getFormattedExpression());
                continue;
            }
            if (line.startsWith("InputMappings")) {
                for (Statement subStatement : statement.getContents()) {
                    mapping = this.readInputMapping(subStatement);
                    ShaderNodeVariable rightVariable = mapping.getRightVariable();
                    if (rightVariable != null) {
                        unusedNodes.remove(rightVariable.getNameSpace());
                    }
                    this.shaderNode.getInputMapping().add(mapping);
                }
                continue;
            }
            if (line.startsWith("OutputMappings")) {
                for (Statement statement1 : statement.getContents()) {
                    mapping = this.readOutputMapping(statement1);
                    unusedNodes.remove(this.shaderNode.getName());
                    this.shaderNode.getOutputMapping().add(mapping);
                }
                continue;
            }
            throw new MatParseException("ShaderNodeDefinition", split[0], statement);
        }
    }

    protected VariableMapping parseMapping(Statement statement, boolean[] hasNameSpace) throws MatParseException {
        VariableMapping mapping = new VariableMapping();
        String[] cond = statement.getLine().split(":");
        String[] vars = cond[0].split("=");
        this.checkMappingFormat(vars, statement);
        ShaderNodeVariable[] variables = new ShaderNodeVariable[2];
        String[] swizzle = new String[2];
        String rightExpression = null;
        for (int i = 0; i < vars.length; ++i) {
            String var = vars[i].trim();
            if (var.contains("%%")) {
                rightExpression = var.substring(2, var.length() - 2);
                continue;
            }
            String[] expression = var.split("\\.");
            if (hasNameSpace[i]) {
                if (expression.length <= 3) {
                    variables[i] = new ShaderNodeVariable("", expression[0].trim(), expression[1].trim());
                }
                if (expression.length != 3) continue;
                swizzle[i] = expression[2].trim();
                continue;
            }
            if (expression.length <= 2) {
                variables[i] = new ShaderNodeVariable("", expression[0].trim());
            }
            if (expression.length != 2) continue;
            swizzle[i] = expression[1].trim();
        }
        mapping.setLeftVariable(variables[0]);
        mapping.setLeftSwizzling(swizzle[0] != null ? swizzle[0] : "");
        if (rightExpression != null) {
            mapping.setRightExpression(rightExpression);
        } else {
            mapping.setRightVariable(variables[1]);
            mapping.setRightSwizzling(swizzle[1] != null ? swizzle[1] : "");
        }
        if (cond.length > 1) {
            this.extractCondition(cond[1], statement);
            mapping.setCondition(this.conditionParser.getFormattedExpression());
        }
        return mapping;
    }

    public void readFragmentShaderNodes(List<Statement> statements) throws IOException {
        this.readNodes(statements);
    }

    protected void readShaderStatement(Statement statement) throws IOException {
        String[] split = statement.getLine().split(":");
        if (split.length != 2) {
            throw new MatParseException("Shader statement syntax incorrect", statement);
        }
        String[] typeAndLang = split[0].split("\\p{javaWhitespace}+");
        if (typeAndLang.length != 2) {
            throw new MatParseException("Shader statement syntax incorrect", statement);
        }
        this.shaderName = split[1].trim();
        this.shaderLanguage = typeAndLang[1];
    }

    public void setTechniqueDef(TechniqueDef techniqueDef) {
        this.techniqueDef = techniqueDef;
    }

    public void setMaterialDef(MaterialDef materialDef) {
        this.materialDef = materialDef;
    }

    protected boolean updateVariableFromList(ShaderNodeVariable var, List<ShaderNodeVariable> list) {
        for (ShaderNodeVariable shaderNodeVariable : list) {
            if (!shaderNodeVariable.getName().equals(var.getName())) continue;
            var.setType(shaderNodeVariable.getType());
            var.setMultiplicity(shaderNodeVariable.getMultiplicity());
            var.setNameSpace(this.shaderNode.getName());
            return true;
        }
        return false;
    }

    protected void updateRightTypeFromLeftType(VariableMapping mapping) {
        String type = mapping.getLeftVariable().getType();
        int card = ShaderUtils.getCardinality(type, mapping.getRightSwizzling());
        if (card > 0) {
            type = card == 1 ? "float" : "vec" + card;
        }
        mapping.getRightVariable().setType(type);
    }

    protected void checkMappingFormat(String[] vars, Statement statement) throws MatParseException {
        if (vars.length != 2) {
            throw new MatParseException("Not a valid expression should be '<varName>[.<swizzling>] = <nameSpace>.<varName>[.<swizzling>][:Condition]'", statement);
        }
    }

    protected MatParam findMatParam(String varName) {
        for (MatParam matParam : this.materialDef.getMaterialParams()) {
            if (!varName.equals(matParam.getName())) continue;
            return matParam;
        }
        return null;
    }

    protected UniformBinding findWorldParam(String varName) {
        for (UniformBinding worldParam : this.techniqueDef.getWorldBindings()) {
            if (!varName.equals(worldParam.toString())) continue;
            return worldParam;
        }
        return null;
    }

    protected boolean updateRightFromUniforms(UniformBinding param, VariableMapping mapping, Map<String, DeclaredVariable> map) {
        ShaderNodeVariable right = mapping.getRightVariable();
        String name = param.toString();
        DeclaredVariable dv = map.get(name);
        if (dv == null) {
            right.setType(param.getGlslType());
            right.setName(name);
            right.setPrefix("g_");
            dv = new DeclaredVariable(right);
            map.put(right.getName(), dv);
            dv.addNode(this.shaderNode);
            mapping.setRightVariable(right);
            return true;
        }
        dv.addNode(this.shaderNode);
        mapping.setRightVariable(dv.var);
        return false;
    }

    public boolean updateRightFromUniforms(MatParam param, VariableMapping mapping, Map<String, DeclaredVariable> map, Statement statement) throws MatParseException {
        ShaderNodeVariable left = mapping.getLeftVariable();
        ShaderNodeVariable right = mapping.getRightVariable();
        DeclaredVariable dv = map.get(param.getName());
        if (dv == null) {
            right.setType(param.getVarType().getGlslType());
            right.setName(param.getName());
            right.setPrefix("m_");
            if (left.getMultiplicity() != null) {
                if (!param.getVarType().name().endsWith("Array")) {
                    throw new MatParseException(param.getName() + " is not of Array type", statement);
                }
                String multiplicity = left.getMultiplicity();
                try {
                    Integer.parseInt(multiplicity);
                }
                catch (NumberFormatException nfe) {
                    MatParam mp = this.findMatParam(multiplicity);
                    if (mp != null) {
                        this.addDefine(multiplicity, VarType.Int);
                        multiplicity = multiplicity.toUpperCase();
                        left.setMultiplicity(multiplicity);
                        left.setCondition(this.mergeConditions(left.getCondition(), "defined(" + multiplicity + ")", "||"));
                    }
                    throw new MatParseException("Wrong multiplicity for variable" + left.getName() + ". " + multiplicity + " should be an int or a declared material parameter.", statement);
                }
                right.setMultiplicity(multiplicity);
                right.setCondition(left.getCondition());
            }
            dv = new DeclaredVariable(right);
            map.put(right.getName(), dv);
            dv.addNode(this.shaderNode);
            mapping.setRightVariable(right);
            return true;
        }
        dv.addNode(this.shaderNode);
        mapping.setRightVariable(dv.var);
        return false;
    }

    public void updateVarFromAttributes(ShaderNodeVariable right, VariableMapping mapping) {
        DeclaredVariable dv = this.attributes.get(right.getName());
        if (dv == null) {
            dv = new DeclaredVariable(right);
            this.attributes.put(right.getName(), dv);
            this.updateRightTypeFromLeftType(mapping);
        } else {
            mapping.setRightVariable(dv.var);
        }
        dv.addNode(this.shaderNode);
    }

    public void addDefine(String paramName, VarType paramType) {
        if (this.techniqueDef.getShaderParamDefine(paramName) == null) {
            this.techniqueDef.addShaderParamDefine(paramName, paramType, paramName.toUpperCase());
        }
    }

    public ShaderNodeVariable findNodeOutput(List<ShaderNodeVariable> vars, String rightVarName) {
        ShaderNodeVariable var = null;
        for (ShaderNodeVariable variable : vars) {
            if (!variable.getName().equals(rightVarName)) continue;
            var = variable;
        }
        return var;
    }

    public void extractCondition(String condition, Statement statement) throws MatParseException {
        List<String> defines = this.conditionParser.extractDefines(condition);
        for (String string : defines) {
            MatParam param = this.findMatParam(string);
            if (param != null) {
                this.addDefine(param.getName(), param.getVarType());
                continue;
            }
            throw new MatParseException("Invalid condition, condition must match a Material Parameter named " + condition, statement);
        }
    }

    public VariableMapping readInputMapping(Statement statement) throws MatParseException {
        VariableMapping mapping;
        try {
            mapping = this.parseMapping(statement, IM_HAS_NAME_SPACE);
        }
        catch (Exception e) {
            throw new MatParseException("Unexpected mapping format", statement, e);
        }
        ShaderNodeDefinition definition = this.shaderNode.getDefinition();
        ShaderNodeVariable left = mapping.getLeftVariable();
        ShaderNodeVariable right = mapping.getRightVariable();
        String expression = mapping.getRightExpression();
        if (!this.updateVariableFromList(left, definition.getInputs())) {
            throw new MatParseException(left.getName() + " is not an input variable of " + definition.getName(), statement);
        }
        if (left.getType().startsWith("sampler") && (right == null || !right.getNameSpace().equals("MatParam"))) {
            throw new MatParseException("Samplers can only be assigned to MatParams", statement);
        }
        if (right == null && expression == null) {
            throw new MatParseException("The mapping doesn't have a right variable or a right expression.", statement);
        }
        if (right == null) {
            return mapping;
        }
        if (right.getNameSpace().equals("Global")) {
            right.setType("vec4");
            this.storeGlobal(right, statement);
        } else if (right.getNameSpace().equals("Attr")) {
            if (definition.getType() == Shader.ShaderType.Fragment) {
                throw new MatParseException("Cannot have an attribute as input in a fragment shader" + right.getName(), statement);
            }
            this.updateVarFromAttributes(mapping.getRightVariable(), mapping);
            this.storeAttribute(mapping.getRightVariable());
        } else if (right.getNameSpace().equals("MatParam")) {
            MatParam param = this.findMatParam(right.getName());
            if (param == null) {
                throw new MatParseException("Could not find a Material Parameter named " + right.getName(), statement);
            }
            if (definition.getType() == Shader.ShaderType.Vertex) {
                if (this.updateRightFromUniforms(param, mapping, this.vertexDeclaredUniforms, statement)) {
                    this.updateMaterialTextureType(statement, mapping, left, param);
                    this.storeVertexUniform(mapping.getRightVariable());
                }
            } else if (this.updateRightFromUniforms(param, mapping, this.fragmentDeclaredUniforms, statement)) {
                this.updateMaterialTextureType(statement, mapping, left, param);
                this.storeFragmentUniform(mapping.getRightVariable());
            }
        } else if (right.getNameSpace().equals("WorldParam")) {
            UniformBinding worldParam = this.findWorldParam(right.getName());
            if (worldParam == null) {
                throw new MatParseException("Could not find a World Parameter named " + right.getName(), statement);
            }
            if (definition.getType() == Shader.ShaderType.Vertex) {
                if (this.updateRightFromUniforms(worldParam, mapping, this.vertexDeclaredUniforms)) {
                    this.storeVertexUniform(mapping.getRightVariable());
                }
            } else if (this.updateRightFromUniforms(worldParam, mapping, this.fragmentDeclaredUniforms)) {
                this.storeFragmentUniform(mapping.getRightVariable());
            }
        } else {
            ShaderNode node = this.nodes.get(right.getNameSpace());
            if (node == null) {
                throw new MatParseException("Undeclared node" + right.getNameSpace() + ". Make sure this node is declared before the current node", statement);
            }
            ShaderNodeVariable var = this.findNodeOutput(node.getDefinition().getOutputs(), right.getName());
            if (var == null) {
                throw new MatParseException("Cannot find output variable" + right.getName() + " form ShaderNode " + node.getName(), statement);
            }
            right.setNameSpace(node.getName());
            right.setType(var.getType());
            right.setMultiplicity(var.getMultiplicity());
            mapping.setRightVariable(right);
            this.storeVaryings(node, mapping.getRightVariable());
        }
        this.checkTypes(mapping, statement);
        return mapping;
    }

    private void updateMaterialTextureType(Statement statement, VariableMapping mapping, ShaderNodeVariable left, MatParam param) throws MatParseException {
        if (!mapping.getRightVariable().getType().contains("|")) {
            return;
        }
        String type = this.fixSamplerType(left.getType(), mapping.getRightVariable().getType());
        if (type == null) {
            throw new MatParseException(param.getVarType().toString() + " can only be matched to one of " + param.getVarType().getGlslType().replaceAll("\\|", ",") + " found " + left.getType(), statement);
        }
        mapping.getRightVariable().setType(type);
    }

    public VariableMapping readOutputMapping(Statement statement) throws MatParseException {
        VariableMapping mapping;
        try {
            mapping = this.parseMapping(statement, OM_HAS_NAME_SPACE);
        }
        catch (Exception e) {
            throw new MatParseException("Unexpected mapping format", statement, e);
        }
        ShaderNodeDefinition definition = this.shaderNode.getDefinition();
        ShaderNodeVariable left = mapping.getLeftVariable();
        ShaderNodeVariable right = mapping.getRightVariable();
        if (left.getType().startsWith("sampler") || right.getType().startsWith("sampler")) {
            throw new MatParseException("Samplers can only be inputs", statement);
        }
        if (!left.getNameSpace().equals("Global")) {
            throw new MatParseException("Only Global nameSpace is allowed for outputMapping, got" + left.getNameSpace(), statement);
        }
        left.setType("vec4");
        this.storeGlobal(left, statement);
        if (!this.updateVariableFromList(right, definition.getOutputs())) {
            throw new MatParseException(right.getName() + " is not an output variable of " + definition.getName(), statement);
        }
        this.checkTypes(mapping, statement);
        return mapping;
    }

    public void readNodes(List<Statement> statements) throws IOException {
        if (this.techniqueDef.getShaderNodes() == null) {
            this.techniqueDef.setShaderNodes(new ArrayList<ShaderNode>());
            this.techniqueDef.setShaderGenerationInfo(new ShaderGenerationInfo());
        }
        for (Statement statement : statements) {
            String[] split = statement.getLine().split("[ \\{]");
            if (statement.getLine().startsWith("ShaderNode ")) {
                String name = statement.getLine().substring("ShaderNode".length()).trim();
                if (this.nodes == null) {
                    this.nodes = new HashMap<String, ShaderNode>();
                }
                if (!this.nodes.containsKey(name)) {
                    this.shaderNode = new ShaderNode();
                    this.shaderNode.setName(name);
                    this.techniqueDef.getShaderGenerationInfo().getUnusedNodes().add(name);
                    this.readShaderNode(statement.getContents());
                    this.nodes.put(name, this.shaderNode);
                    this.techniqueDef.getShaderNodes().add(this.shaderNode);
                    continue;
                }
                throw new MatParseException("ShaderNode " + name + " is already defined", statement);
            }
            throw new MatParseException("ShaderNode", split[0], statement);
        }
    }

    public String fixSamplerType(String leftType, String rightType) {
        String[] types;
        for (String string : types = rightType.split("\\|")) {
            if (!leftType.equals(string)) continue;
            return string;
        }
        return null;
    }

    public void storeGlobal(ShaderNodeVariable var, Statement varStatement) throws MatParseException {
        var.setShaderOutput(true);
        ShaderGenerationInfo generationInfo = this.techniqueDef.getShaderGenerationInfo();
        ShaderNodeDefinition definition = this.shaderNode.getDefinition();
        if (definition.getType() == Shader.ShaderType.Vertex) {
            ShaderNodeVariable global = generationInfo.getVertexGlobal();
            if (global != null) {
                if (!global.getName().equals(var.getName())) {
                    throw new MatParseException("A global output is already defined for the vertex shader: " + global.getName() + ". vertex shader can only have one global output", varStatement);
                }
            } else {
                generationInfo.setVertexGlobal(var);
            }
        } else if (definition.getType() == Shader.ShaderType.Fragment) {
            this.storeVariable(var, generationInfo.getFragmentGlobals());
        }
    }

    public void storeAttribute(ShaderNodeVariable var) {
        this.storeVariable(var, this.techniqueDef.getShaderGenerationInfo().getAttributes());
    }

    public void storeVertexUniform(ShaderNodeVariable var) {
        this.storeVariable(var, this.techniqueDef.getShaderGenerationInfo().getVertexUniforms());
    }

    public void storeFragmentUniform(ShaderNodeVariable var) {
        this.storeVariable(var, this.techniqueDef.getShaderGenerationInfo().getFragmentUniforms());
    }

    public void setAssetManager(AssetManager assetManager) {
        this.assetManager = assetManager;
    }

    public ShaderNodeDefinition findDefinition(Statement statement) throws IOException {
        List<ShaderNodeDefinition> defs;
        String[] defLine = statement.getLine().split(":");
        if (defLine.length != 3) {
            throw new MatParseException("Can't find shader node definition for: ", statement);
        }
        Map<String, ShaderNodeDefinition> nodeDefinitions = this.getNodeDefinitions();
        String definitionName = defLine[1].trim();
        String definitionPath = defLine[2].trim();
        String fullName = definitionName + ":" + definitionPath;
        ShaderNodeDefinition def = nodeDefinitions.get(fullName);
        if (def != null) {
            return def;
        }
        try {
            defs = this.assetManager.loadAsset(new ShaderNodeDefinitionKey(definitionPath));
        }
        catch (AssetNotFoundException e) {
            throw new MatParseException("Couldn't find " + definitionPath, statement, e);
        }
        for (ShaderNodeDefinition definition : defs) {
            String key;
            if (definitionName.equals(definition.getName())) {
                def = definition;
            }
            if (nodeDefinitions.containsKey(key = definition.getName() + ":" + definitionPath)) continue;
            nodeDefinitions.put(key, definition);
        }
        if (def == null) {
            throw new MatParseException(definitionName + " is not a declared as Shader Node Definition", statement);
        }
        return def;
    }

    public void storeVaryings(ShaderNode node, ShaderNodeVariable variable) {
        variable.setShaderOutput(true);
        ShaderNodeDefinition nodeDefinition = node.getDefinition();
        ShaderNodeDefinition currentDefinition = this.shaderNode.getDefinition();
        if (nodeDefinition.getType() != Shader.ShaderType.Vertex || currentDefinition.getType() != Shader.ShaderType.Fragment) {
            return;
        }
        String fullName = node.getName() + "." + variable.getName();
        DeclaredVariable declaredVar = this.varyings.get(fullName);
        if (declaredVar == null) {
            this.techniqueDef.getShaderGenerationInfo().getVaryings().add(variable);
            declaredVar = new DeclaredVariable(variable);
            this.varyings.put(fullName, declaredVar);
        }
        declaredVar.addNode(this.shaderNode);
        for (VariableMapping variableMapping : node.getInputMapping()) {
            ShaderNodeVariable leftVariable = variableMapping.getLeftVariable();
            if (!leftVariable.getName().equals(variable.getName())) continue;
            leftVariable.setShaderOutput(true);
        }
    }

    public String mergeConditions(String condition1, String condition2, String operator) {
        if (condition1 != null) {
            if (condition2 == null) {
                return condition1;
            }
            String mergedCondition = "(" + condition1 + ") " + operator + " (" + condition2 + ")";
            return mergedCondition;
        }
        return condition2;
    }

    public void storeVariable(ShaderNodeVariable variable, List<ShaderNodeVariable> varList) {
        for (ShaderNodeVariable var : varList) {
            if (!var.getName().equals(variable.getName())) continue;
            return;
        }
        varList.add(variable);
    }

    protected void checkTypes(VariableMapping mapping, Statement statement1) throws MatParseException {
        if (!ShaderUtils.typesMatch(mapping)) {
            String ls = mapping.getLeftSwizzling().length() == 0 ? "" : "." + mapping.getLeftSwizzling();
            String rs = mapping.getRightSwizzling().length() == 0 ? "" : "." + mapping.getRightSwizzling();
            throw new MatParseException("Type mismatch, cannot convert " + mapping.getRightVariable().getType() + rs + " to " + mapping.getLeftVariable().getType() + ls, statement1);
        }
        if (!ShaderUtils.multiplicityMatch(mapping)) {
            String type1 = mapping.getLeftVariable().getType() + "[" + mapping.getLeftVariable().getMultiplicity() + "]";
            String type2 = mapping.getRightVariable().getType() + "[" + mapping.getRightVariable().getMultiplicity() + "]";
            throw new MatParseException("Type mismatch, cannot convert " + type1 + " to " + type2, statement1);
        }
    }

    private Map<String, ShaderNodeDefinition> getNodeDefinitions() {
        if (this.nodeDefinitions == null) {
            this.nodeDefinitions = new HashMap<String, ShaderNodeDefinition>();
        }
        return this.nodeDefinitions;
    }

    public void clear() {
        this.nodeDefinitions.clear();
        this.nodes.clear();
        this.shaderNodeDefinition = null;
        this.shaderNode = null;
        this.techniqueDef = null;
        this.attributes.clear();
        this.vertexDeclaredUniforms.clear();
        this.fragmentDeclaredUniforms.clear();
        this.varyings.clear();
        this.materialDef = null;
        this.shaderLanguage = "";
        this.shaderName = "";
        this.varNames.clear();
        this.assetManager = null;
        this.nulledConditions.clear();
    }

    protected class DeclaredVariable {
        ShaderNodeVariable var;
        List<ShaderNode> nodes = new ArrayList<ShaderNode>();

        public DeclaredVariable(ShaderNodeVariable var) {
            this.var = var;
        }

        public final void addNode(ShaderNode c) {
            if (!this.nodes.contains(c)) {
                this.nodes.add(c);
            }
        }
    }
}

