/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.font;

import com.jme3.font.BitmapFont;
import com.jme3.font.BitmapTextPage;
import com.jme3.font.Letters;
import com.jme3.font.LineWrapMode;
import com.jme3.font.Rectangle;
import com.jme3.font.StringBlock;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.renderer.RenderManager;
import com.jme3.scene.Node;
import com.jme3.util.clone.Cloner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BitmapText
extends Node {
    private BitmapFont font;
    private StringBlock block;
    private boolean needRefresh = true;
    private BitmapTextPage[] textPages;
    private Letters letters;

    public BitmapText(BitmapFont font) {
        this(font, font.isRightToLeft(), false);
    }

    @Deprecated
    public BitmapText(BitmapFont font, boolean rightToLeft) {
        this(font, rightToLeft, false);
    }

    public BitmapText(BitmapFont font, boolean rightToLeft, boolean arrayBased) {
        this.textPages = new BitmapTextPage[font.getPageSize()];
        for (int page = 0; page < this.textPages.length; ++page) {
            this.textPages[page] = new BitmapTextPage(font, arrayBased, page);
            this.attachChild(this.textPages[page]);
        }
        this.font = font;
        this.block = new StringBlock();
        this.block.setSize(font.getPreferredSize());
        this.letters = new Letters(font, this.block, rightToLeft);
    }

    @Override
    public BitmapText clone() {
        return (BitmapText)super.clone(false);
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        super.cloneFields(cloner, original);
        this.textPages = (BitmapTextPage[])this.textPages.clone();
        for (int i = 0; i < this.textPages.length; ++i) {
            this.textPages[i] = cloner.clone(this.textPages[i]);
        }
        this.block = this.block != null ? this.block.clone() : null;
        this.letters = new Letters(this.font, this.block, this.letters.getQuad().isRightToLeft());
    }

    public BitmapFont getFont() {
        return this.font;
    }

    public void setSize(float size) {
        this.block.setSize(size);
        this.needRefresh = true;
        this.letters.invalidate();
    }

    public float getSize() {
        return this.block.getSize();
    }

    public void setText(CharSequence text) {
        this.setText(text != null ? text.toString() : null);
    }

    public void setText(String text) {
        String string = text = text == null ? "" : text;
        if (text == this.block.getText() || this.block.getText().equals(text)) {
            return;
        }
        this.block.setText(text);
        this.letters.setText(text);
        this.needRefresh = true;
    }

    public String getText() {
        return this.block.getText();
    }

    public ColorRGBA getColor() {
        return this.letters.getBaseColor();
    }

    public void setColor(ColorRGBA color) {
        this.letters.setColor(color);
        this.letters.invalidate();
        this.needRefresh = true;
    }

    public void setAlpha(float alpha) {
        this.letters.setBaseAlpha(alpha);
        this.needRefresh = true;
    }

    public float getAlpha() {
        return this.letters.getBaseAlpha();
    }

    public void setBox(Rectangle rect) {
        this.block.setTextBox(rect);
        this.letters.invalidate();
        this.needRefresh = true;
    }

    public float getLineHeight() {
        return this.font.getLineHeight(this.block);
    }

    public float getHeight() {
        if (this.needRefresh) {
            this.assemble();
        }
        float height = this.getLineHeight() * (float)this.block.getLineCount();
        Rectangle textBox = this.block.getTextBox();
        if (textBox != null) {
            return Math.max(height, textBox.height);
        }
        return height;
    }

    public float getLineWidth() {
        Rectangle textBox;
        if (this.needRefresh) {
            this.assemble();
        }
        if ((textBox = this.block.getTextBox()) != null) {
            return Math.max(this.letters.getTotalWidth(), textBox.width);
        }
        return this.letters.getTotalWidth();
    }

    public int getLineCount() {
        if (this.needRefresh) {
            this.assemble();
        }
        return this.block.getLineCount();
    }

    public LineWrapMode getLineWrapMode() {
        return this.block.getLineWrapMode();
    }

    public void setAlignment(BitmapFont.Align align) {
        if (this.block.getTextBox() == null && align != BitmapFont.Align.Left) {
            throw new RuntimeException("Bound is not set");
        }
        this.block.setAlignment(align);
        this.letters.invalidate();
        this.needRefresh = true;
    }

    public void setVerticalAlignment(BitmapFont.VAlign align) {
        if (this.block.getTextBox() == null && align != BitmapFont.VAlign.Top) {
            throw new RuntimeException("Bound is not set");
        }
        this.block.setVerticalAlignment(align);
        this.letters.invalidate();
        this.needRefresh = true;
    }

    public BitmapFont.Align getAlignment() {
        return this.block.getAlignment();
    }

    public BitmapFont.VAlign getVerticalAlignment() {
        return this.block.getVerticalAlignment();
    }

    public void setStyle(int start, int end, int style) {
        this.letters.setStyle(start, end, style);
    }

    public void setStyle(String regexp, int style) {
        Pattern p = Pattern.compile(regexp);
        Matcher m = p.matcher(this.block.getText());
        while (m.find()) {
            this.setStyle(m.start(), m.end(), style);
        }
    }

    public void setColor(int start, int end, ColorRGBA color) {
        this.letters.setColor(start, end, color);
        this.letters.invalidate();
        this.needRefresh = true;
    }

    public void setColor(String regexp, ColorRGBA color) {
        Pattern p = Pattern.compile(regexp);
        Matcher m = p.matcher(this.block.getText());
        while (m.find()) {
            this.letters.setColor(m.start(), m.end(), color);
        }
        this.letters.invalidate();
        this.needRefresh = true;
    }

    public void setTabPosition(float ... tabs) {
        this.block.setTabPosition(tabs);
        this.letters.invalidate();
        this.needRefresh = true;
    }

    public void setTabWidth(float width) {
        this.block.setTabWidth(width);
        this.letters.invalidate();
        this.needRefresh = true;
    }

    public void setEllipsisChar(char c) {
        this.block.setEllipsisChar(c);
        this.letters.invalidate();
        this.needRefresh = true;
    }

    public void setLineWrapMode(LineWrapMode wrap) {
        if (this.block.getLineWrapMode() != wrap) {
            this.block.setLineWrapMode(wrap);
            this.letters.invalidate();
            this.needRefresh = true;
        }
    }

    @Override
    public void updateLogicalState(float tpf) {
        super.updateLogicalState(tpf);
        if (this.needRefresh) {
            this.assemble();
        }
    }

    private void assemble() {
        this.letters.update();
        for (int i = 0; i < this.textPages.length; ++i) {
            this.textPages[i].assemble(this.letters);
        }
        this.needRefresh = false;
    }

    public void render(RenderManager rm, ColorRGBA color) {
        for (BitmapTextPage page : this.textPages) {
            Material mat = page.getMaterial();
            mat.setTexture("ColorMap", page.getTexture());
            mat.render(page, rm);
        }
    }
}

