/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.environment.baker;

import com.jme3.asset.AssetManager;
import com.jme3.environment.baker.IBLHybridEnvBakerLight;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Caps;
import com.jme3.renderer.RenderManager;
import com.jme3.scene.Geometry;
import com.jme3.scene.shape.Box;
import com.jme3.texture.FrameBuffer;
import com.jme3.texture.Image;
import com.jme3.texture.Texture2D;
import com.jme3.texture.image.ColorSpace;
import com.jme3.texture.image.ImageRaster;
import com.jme3.util.BufferUtils;
import java.nio.ByteBuffer;
import java.util.logging.Logger;

public class IBLGLEnvBakerLight
extends IBLHybridEnvBakerLight {
    private static final int NUM_SH_COEFFICIENT = 9;
    private static final Logger LOG = Logger.getLogger(IBLGLEnvBakerLight.class.getName());

    public IBLGLEnvBakerLight(RenderManager rm, AssetManager am, Image.Format format, Image.Format depthFormat, int env_size, int specular_size) {
        super(rm, am, format, depthFormat, env_size, specular_size);
    }

    @Override
    public boolean isTexturePulling() {
        return this.texturePulling;
    }

    @Override
    public void bakeSphericalHarmonicsCoefficients() {
        int i;
        Box boxm = new Box(1.0f, 1.0f, 1.0f);
        Geometry screen = new Geometry("BakeBox", boxm);
        Material mat = new Material(this.assetManager, "Common/IBLSphH/IBLSphH.j3md");
        mat.setTexture("Texture", this.envMap);
        mat.setVector2("Resolution", new Vector2f(this.envMap.getImage().getWidth(), this.envMap.getImage().getHeight()));
        screen.setMaterial(mat);
        float remapMaxValue = 0.0f;
        Image.Format format = Image.Format.RGBA32F;
        if (!this.renderManager.getRenderer().getCaps().contains((Object)Caps.FloatColorBufferRGBA)) {
            LOG.warning("Float textures not supported, using RGB8 instead. This may cause accuracy issues.");
            format = Image.Format.RGBA8;
            remapMaxValue = 0.05f;
        }
        if (remapMaxValue > 0.0f) {
            mat.setFloat("RemapMaxValue", remapMaxValue);
        } else {
            mat.clearParam("RemapMaxValue");
        }
        Texture2D[] shCoefTx = new Texture2D[]{new Texture2D(9, 1, 1, format), new Texture2D(9, 1, 1, format)};
        FrameBuffer[] shbaker = new FrameBuffer[]{new FrameBuffer(9, 1, 1), new FrameBuffer(9, 1, 1)};
        shbaker[0].setSrgb(false);
        shbaker[0].addColorTarget(FrameBuffer.FrameBufferTarget.newTarget(shCoefTx[0]));
        shbaker[1].setSrgb(false);
        shbaker[1].addColorTarget(FrameBuffer.FrameBufferTarget.newTarget(shCoefTx[1]));
        int renderOnT = -1;
        for (int faceId = 0; faceId < 6; ++faceId) {
            if (renderOnT != -1) {
                int s = renderOnT;
                renderOnT = renderOnT == 0 ? 1 : 0;
                mat.setTexture("ShCoef", shCoefTx[s]);
                mat.setInt("FaceId", faceId);
            } else {
                renderOnT = 0;
            }
            screen.updateLogicalState(0.0f);
            screen.updateGeometricState();
            this.renderManager.setCamera(this.updateAndGetInternalCamera(0, shbaker[renderOnT].getWidth(), shbaker[renderOnT].getHeight(), Vector3f.ZERO, 1.0f, 1000.0f), false);
            this.renderManager.getRenderer().setFrameBuffer(shbaker[renderOnT]);
            this.renderManager.renderGeometry(screen);
        }
        ByteBuffer shCoefRaw = BufferUtils.createByteBuffer(9 * (shbaker[renderOnT].getColorTarget().getFormat().getBitsPerPixel() / 8));
        this.renderManager.getRenderer().readFrameBufferWithFormat(shbaker[renderOnT], shCoefRaw, shbaker[renderOnT].getColorTarget().getFormat());
        shCoefRaw.rewind();
        Image img = new Image(format, 9, 1, shCoefRaw, ColorSpace.Linear);
        ImageRaster imgr = ImageRaster.create(img);
        this.shCoef = new Vector3f[9];
        float weightAccum = 0.0f;
        for (i = 0; i < this.shCoef.length; ++i) {
            ColorRGBA c = imgr.getPixel(i, 0);
            this.shCoef[i] = new Vector3f(c.r, c.g, c.b);
            if (weightAccum == 0.0f) {
                weightAccum = c.a;
                continue;
            }
            if (weightAccum == c.a) continue;
            LOG.warning("SH weight is not uniform, this may cause issues.");
        }
        if (remapMaxValue > 0.0f) {
            weightAccum /= remapMaxValue;
        }
        for (i = 0; i < 9; ++i) {
            if (remapMaxValue > 0.0f) {
                this.shCoef[i].divideLocal(remapMaxValue);
            }
            this.shCoef[i].multLocal((float)Math.PI * 4 / weightAccum);
        }
        img.dispose();
    }
}

