/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.audio;

import com.jme3.audio.AudioRenderer;
import com.jme3.audio.ListenerParam;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;

public class Listener {
    private final Vector3f location;
    private final Vector3f velocity;
    private final Quaternion rotation;
    private float volume = 1.0f;
    private AudioRenderer renderer;

    public Listener() {
        this.location = new Vector3f();
        this.velocity = new Vector3f();
        this.rotation = new Quaternion();
    }

    public Listener(Listener source) {
        this.location = source.location.clone();
        this.velocity = source.velocity.clone();
        this.rotation = source.rotation.clone();
        this.volume = source.volume;
    }

    public void setRenderer(AudioRenderer renderer) {
        this.renderer = renderer;
    }

    public float getVolume() {
        return this.volume;
    }

    public void setVolume(float volume) {
        this.volume = volume;
        if (this.renderer != null) {
            this.renderer.updateListenerParam(this, ListenerParam.Volume);
        }
    }

    public Vector3f getLocation() {
        return this.location;
    }

    public Quaternion getRotation() {
        return this.rotation;
    }

    public Vector3f getVelocity() {
        return this.velocity;
    }

    public Vector3f getLeft() {
        return this.rotation.getRotationColumn(0);
    }

    public Vector3f getUp() {
        return this.rotation.getRotationColumn(1);
    }

    public Vector3f getDirection() {
        return this.rotation.getRotationColumn(2);
    }

    public void setLocation(Vector3f location) {
        this.location.set(location);
        if (this.renderer != null) {
            this.renderer.updateListenerParam(this, ListenerParam.Position);
        }
    }

    public void setRotation(Quaternion rotation) {
        this.rotation.set(rotation);
        if (this.renderer != null) {
            this.renderer.updateListenerParam(this, ListenerParam.Rotation);
        }
    }

    public void setVelocity(Vector3f velocity) {
        this.velocity.set(velocity);
        if (this.renderer != null) {
            this.renderer.updateListenerParam(this, ListenerParam.Velocity);
        }
    }
}

