/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.anim.interpolator;

import com.jme3.anim.interpolator.AnimInterpolator;
import com.jme3.anim.interpolator.AnimInterpolators;
import com.jme3.animation.CompactArray;
import com.jme3.animation.CompactQuaternionArray;
import com.jme3.animation.CompactVector3Array;
import com.jme3.math.FastMath;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;

public class FrameInterpolator {
    @Deprecated
    public static final FrameInterpolator DEFAULT = new FrameInterpolator();
    private static final ThreadLocal<FrameInterpolator> THREAD_DEFAULT = ThreadLocal.withInitial(() -> new FrameInterpolator());
    private AnimInterpolator<Float> timeInterpolator;
    private AnimInterpolator<Vector3f> translationInterpolator = AnimInterpolators.LinearVec3f;
    private AnimInterpolator<Quaternion> rotationInterpolator = AnimInterpolators.NLerp;
    private AnimInterpolator<Vector3f> scaleInterpolator = AnimInterpolators.LinearVec3f;
    private final TrackDataReader<Vector3f> translationReader = new TrackDataReader();
    private final TrackDataReader<Quaternion> rotationReader = new TrackDataReader();
    private final TrackDataReader<Vector3f> scaleReader = new TrackDataReader();
    private final TrackTimeReader timesReader = new TrackTimeReader();
    private final Transform transforms = new Transform();

    public static FrameInterpolator getThreadDefault() {
        FrameInterpolator result = THREAD_DEFAULT.get();
        return result;
    }

    public Transform interpolate(float t, int currentIndex, CompactVector3Array translations, CompactQuaternionArray rotations, CompactVector3Array scales, float[] times) {
        this.timesReader.setData(times);
        if (this.timeInterpolator != null) {
            t = ((Float)this.timeInterpolator.interpolate(t, currentIndex, null, this.timesReader, null)).floatValue();
        }
        if (translations != null) {
            this.translationReader.setData(translations);
            this.translationInterpolator.interpolate(t, currentIndex, this.translationReader, this.timesReader, this.transforms.getTranslation());
        }
        if (rotations != null) {
            this.rotationReader.setData(rotations);
            this.rotationInterpolator.interpolate(t, currentIndex, this.rotationReader, this.timesReader, this.transforms.getRotation());
        }
        if (scales != null) {
            this.scaleReader.setData(scales);
            this.scaleInterpolator.interpolate(t, currentIndex, this.scaleReader, this.timesReader, this.transforms.getScale());
        }
        return this.transforms;
    }

    public void interpolateWeights(float t, int currentIndex, float[] weights, int nbMorphTargets, float[] store) {
        int start = currentIndex * nbMorphTargets;
        for (int i = 0; i < nbMorphTargets; ++i) {
            float val;
            int current = start + i;
            int next = current + nbMorphTargets;
            if (next >= weights.length) {
                next = current;
            }
            store[i] = val = FastMath.interpolateLinear(t, weights[current], weights[next]);
        }
    }

    public void setTimeInterpolator(AnimInterpolator<Float> timeInterpolator) {
        this.timeInterpolator = timeInterpolator;
    }

    public void setTranslationInterpolator(AnimInterpolator<Vector3f> translationInterpolator) {
        this.translationInterpolator = translationInterpolator;
    }

    public void setRotationInterpolator(AnimInterpolator<Quaternion> rotationInterpolator) {
        this.rotationInterpolator = rotationInterpolator;
    }

    public void setScaleInterpolator(AnimInterpolator<Vector3f> scaleInterpolator) {
        this.scaleInterpolator = scaleInterpolator;
    }

    private static int mod(int val, int n) {
        return (val % n + n) % n;
    }

    public static class TrackDataReader<T> {
        private CompactArray<T> data;

        protected void setData(CompactArray<T> data) {
            this.data = data;
        }

        public T getEntryMod(int index, T store) {
            return this.data.get(FrameInterpolator.mod(index, this.data.getTotalObjectSize()), store);
        }

        public T getEntryClamp(int index, T store) {
            index = (int)FastMath.clamp(index, 0.0f, this.data.getTotalObjectSize() - 1);
            return this.data.get(index, store);
        }

        public T getEntryModSkip(int index, T store) {
            int total = this.data.getTotalObjectSize();
            if (index == -1) {
                --index;
            } else if (index >= total) {
                ++index;
            }
            index = FrameInterpolator.mod(index, total);
            return this.data.get(index, store);
        }
    }

    public static class TrackTimeReader {
        private float[] data;

        protected void setData(float[] data) {
            this.data = data;
        }

        public float getEntry(int index) {
            return this.data[FrameInterpolator.mod(index, this.data.length)];
        }

        public int getLength() {
            return this.data.length;
        }
    }
}

