/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.plugins.json;

import com.jme3.plugins.json.JsonParser;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Json {
    public static final String PROPERTY_JSON_PARSER_IMPLEMENTATION = "com.jme3.JsonParserImplementation";
    private static final Logger LOGGER = Logger.getLogger(Json.class.getName());
    private static final String DEFAULT_JSON_PARSER_IMPLEMENTATION = "com.jme3.plugins.gson.GsonParser";
    private static Class<? extends JsonParser> clazz = null;

    public static void setParser(Class<? extends JsonParser> clazz) {
        Json.clazz = clazz;
    }

    private static Class<? extends JsonParser> findJsonParser(String className) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
        }
        catch (Throwable e) {
            LOGGER.log(Level.WARNING, "Unable to access {0}", className);
        }
        if (clazz != null && !JsonParser.class.isAssignableFrom(clazz)) {
            LOGGER.log(Level.WARNING, "{0} does not implement {1}", new Object[]{className, JsonParser.class.getName()});
            clazz = null;
        }
        return clazz;
    }

    public static JsonParser create() {
        if (clazz == null) {
            String userDefinedImpl = System.getProperty(PROPERTY_JSON_PARSER_IMPLEMENTATION, null);
            if (userDefinedImpl != null) {
                LOGGER.log(Level.FINE, "Loading user defined JsonParser implementation {0}", userDefinedImpl);
                clazz = Json.findJsonParser(userDefinedImpl);
            }
            if (clazz == null) {
                LOGGER.log(Level.FINE, "No usable user defined JsonParser implementation found, using default implementation {0}", DEFAULT_JSON_PARSER_IMPLEMENTATION);
                clazz = Json.findJsonParser(DEFAULT_JSON_PARSER_IMPLEMENTATION);
            }
        }
        if (clazz == null) {
            throw new RuntimeException("No JsonParser implementation found");
        }
        try {
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not instantiate JsonParser class " + clazz.getName(), e);
        }
    }
}

