/*
 * Decompiled with CFR 0.152.
 */
package cz.advel.stack.instrument;

import cz.advel.stack.instrument.InstrumentMethod;
import cz.advel.stack.instrument.Instrumenter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;

class InstrumentClass
extends ClassAdapter {
    private final Instrumenter instr;
    private final Set<String> methods;
    private String className;
    private boolean disableMethodInstrumentation = false;
    private MethodNode clinitMethod;
    private final List<String> tempStaticFields = new ArrayList<String>();

    InstrumentClass(ClassVisitor cv, Instrumenter instr, Set<String> methods) {
        super(cv);
        this.instr = instr;
        this.methods = methods;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.className = name;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (this.disableMethodInstrumentation) {
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
        if (this.methods.contains(name)) {
            InstrumentMethod im = new InstrumentMethod(access, name, desc, signature, exceptions, this.instr, this, this.className, this.cv);
            if (this.isInitializerInstrumentationNeeded() && name.equals("<clinit>")) {
                im.emitMethod = false;
                this.clinitMethod = im;
            }
            return im;
        }
        if (this.isInitializerInstrumentationNeeded() && name.equals("<clinit>")) {
            this.clinitMethod = new MethodNode(access, name, desc, signature, exceptions);
            return this.clinitMethod;
        }
        return super.visitMethod(access, name, desc, signature, exceptions);
    }

    public void visitEnd() {
        if (this.isInitializerInstrumentationNeeded()) {
            if (this.tempStaticFields.size() > 0 && this.clinitMethod == null) {
                this.clinitMethod = new MethodNode(8, "<clinit>", "()V", null, null);
                this.clinitMethod.instructions.add((AbstractInsnNode)new InsnNode(177));
            }
            for (int i = 0; i < this.tempStaticFields.size(); ++i) {
                FieldVisitor fv = this.visitField(26, "$stackTemp" + i, "L" + this.tempStaticFields.get(i) + ";", null, null);
                fv.visitEnd();
            }
            if (this.clinitMethod != null) {
                InsnList list = new InsnList();
                for (int i = 0; i < this.tempStaticFields.size(); ++i) {
                    list.add((AbstractInsnNode)new TypeInsnNode(187, this.tempStaticFields.get(i)));
                    list.add((AbstractInsnNode)new InsnNode(89));
                    list.add((AbstractInsnNode)new MethodInsnNode(183, this.tempStaticFields.get(i), "<init>", "()V"));
                    list.add((AbstractInsnNode)new FieldInsnNode(179, this.className, "$stackTemp" + i, "L" + this.tempStaticFields.get(i) + ";"));
                }
                this.clinitMethod.instructions.insertBefore(this.clinitMethod.instructions.getFirst(), list);
                this.disableMethodInstrumentation = true;
                this.clinitMethod.accept((ClassVisitor)this);
            }
        }
        super.visitEnd();
    }

    private boolean isInitializerInstrumentationNeeded() {
        return this.instr.isSingleThread();
    }

    public int registerStaticAlloc(String type) {
        this.tempStaticFields.add(type);
        return this.tempStaticFields.size() - 1;
    }
}

