/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.opencl.lwjgl;

import com.jme3.opencl.CommandQueue;
import com.jme3.opencl.Device;
import com.jme3.opencl.OpenCLObject;
import com.jme3.opencl.lwjgl.Utils;
import org.lwjgl.opencl.CL10;
import org.lwjgl.opencl.CLCommandQueue;

public class LwjglCommandQueue
extends CommandQueue {
    private final CLCommandQueue queue;

    public LwjglCommandQueue(CLCommandQueue queue, Device device) {
        super((OpenCLObject.ObjectReleaser)new ReleaserImpl(queue), device);
        this.queue = queue;
    }

    public CLCommandQueue getQueue() {
        return this.queue;
    }

    public void flush() {
        int ret = CL10.clFlush((CLCommandQueue)this.queue);
        Utils.checkError(ret, "clFlush");
    }

    public void finish() {
        int ret = CL10.clFinish((CLCommandQueue)this.queue);
        Utils.checkError(ret, "clFinish");
    }

    private static class ReleaserImpl
    implements OpenCLObject.ObjectReleaser {
        private CLCommandQueue queue;

        private ReleaserImpl(CLCommandQueue queue) {
            this.queue = queue;
        }

        public void release() {
            if (this.queue != null) {
                int ret = CL10.clReleaseCommandQueue((CLCommandQueue)this.queue);
                this.queue = null;
                Utils.reportError(ret, "clReleaseCommandQueue");
            }
        }
    }
}

