/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.post.filters;

import com.jme3.asset.AssetManager;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.material.Material;
import com.jme3.post.Filter;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import java.io.IOException;

public class ContrastAdjustmentFilter
extends Filter {
    private float redExponent = 1.0f;
    private float greenExponent = 1.0f;
    private float blueExponent = 1.0f;
    private float lowerLimit = 0.0f;
    private float upperLimit = 1.0f;
    private float redScale = 1.0f;
    private float greenScale = 1.0f;
    private float blueScale = 1.0f;

    public ContrastAdjustmentFilter() {
        super("Contrast Adjustment");
    }

    public ContrastAdjustmentFilter(float exponent) {
        this();
        this.redExponent = exponent;
        this.greenExponent = exponent;
        this.blueExponent = exponent;
    }

    public ContrastAdjustmentFilter setExponents(float redExponent, float greenExponent, float blueExponent) {
        this.setRedExponent(redExponent);
        this.setGreenExponent(greenExponent);
        this.setBlueExponent(blueExponent);
        return this;
    }

    public ContrastAdjustmentFilter setRedExponent(float exponent) {
        this.redExponent = exponent;
        if (this.material != null) {
            this.material.setFloat("redChannelExponent", this.redExponent);
        }
        return this;
    }

    public ContrastAdjustmentFilter setGreenExponent(float exponent) {
        this.greenExponent = exponent;
        if (this.material != null) {
            this.material.setFloat("greenChannelExponent", this.greenExponent);
        }
        return this;
    }

    public ContrastAdjustmentFilter setBlueExponent(float exponent) {
        this.blueExponent = exponent;
        if (this.material != null) {
            this.material.setFloat("blueChannelExponent", this.blueExponent);
        }
        return this;
    }

    public float getRedExponent() {
        return this.redExponent;
    }

    public float getGreenExponent() {
        return this.greenExponent;
    }

    public float getBlueExponent() {
        return this.blueExponent;
    }

    public ContrastAdjustmentFilter setInputRange(float lowerLimit, float upperLimit) {
        this.setLowerLimit(lowerLimit);
        this.setUpperLimit(upperLimit);
        return this;
    }

    public ContrastAdjustmentFilter setUpperLimit(float level) {
        this.upperLimit = level;
        if (this.material != null) {
            this.material.setFloat("upperLimit", this.upperLimit);
        }
        return this;
    }

    public ContrastAdjustmentFilter setLowerLimit(float level) {
        this.lowerLimit = level;
        if (this.material != null) {
            this.material.setFloat("lowerLimit", this.lowerLimit);
        }
        return this;
    }

    public float getLowerLimit() {
        return this.lowerLimit;
    }

    public float getUpperLimit() {
        return this.upperLimit;
    }

    public ContrastAdjustmentFilter setScales(float redScale, float greenScale, float blueScale) {
        this.setRedScale(redScale);
        this.setGreenScale(greenScale);
        this.setBlueScale(blueScale);
        return this;
    }

    public ContrastAdjustmentFilter setRedScale(float factor) {
        this.redScale = factor;
        if (this.material != null) {
            this.material.setFloat("redChannelScale", this.redScale);
        }
        return this;
    }

    public ContrastAdjustmentFilter setGreenScale(float factor) {
        this.greenScale = factor;
        if (this.material != null) {
            this.material.setFloat("greenChannelScale", this.greenScale);
        }
        return this;
    }

    public ContrastAdjustmentFilter setBlueScale(float factor) {
        this.blueScale = factor;
        if (this.material != null) {
            this.material.setFloat("blueChannelScale", this.blueScale);
        }
        return this;
    }

    public float getRedScale() {
        return this.redScale;
    }

    public float getGreenScale() {
        return this.greenScale;
    }

    public float getBlueScale() {
        return this.blueScale;
    }

    protected void initFilter(AssetManager assetManager, RenderManager renderManager, ViewPort viewPort, int width, int height) {
        this.material = new Material(assetManager, "Common/MatDefs/Post/ContrastAdjustment.j3md");
        this.setExponents(this.redExponent, this.greenExponent, this.blueExponent);
        this.setInputRange(this.lowerLimit, this.upperLimit);
        this.setScales(this.redScale, this.greenScale, this.blueScale);
    }

    protected Material getMaterial() {
        return this.material;
    }

    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule inputCapsule = im.getCapsule((Savable)this);
        this.redExponent = inputCapsule.readFloat("redExponent", 1.0f);
        this.greenExponent = inputCapsule.readFloat("greenExponent", 1.0f);
        this.blueExponent = inputCapsule.readFloat("blueExponent", 1.0f);
        this.lowerLimit = inputCapsule.readFloat("lowerLimit", 0.0f);
        this.upperLimit = inputCapsule.readFloat("upperLimit", 1.0f);
        this.redScale = inputCapsule.readFloat("redScale", 1.0f);
        this.greenScale = inputCapsule.readFloat("greenScale", 1.0f);
        this.blueScale = inputCapsule.readFloat("blueScale", 1.0f);
    }

    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule outputCapsule = ex.getCapsule((Savable)this);
        outputCapsule.write(this.redExponent, "redExponent", 1.0f);
        outputCapsule.write(this.greenExponent, "greenExponent", 1.0f);
        outputCapsule.write(this.blueExponent, "blueExponent", 1.0f);
        outputCapsule.write(this.lowerLimit, "lowerLimit", 0.0f);
        outputCapsule.write(this.upperLimit, "upperLimit", 1.0f);
        outputCapsule.write(this.redScale, "redScale", 1.0f);
        outputCapsule.write(this.greenScale, "greenScale", 1.0f);
        outputCapsule.write(this.blueScale, "blueScale", 1.0f);
    }

    public String toString() {
        String result = String.format("input(%.3f, %.3f) exp(%.3f, %.3f, %.3f) scale(%.3f, %.3f, %.3f)", Float.valueOf(this.lowerLimit), Float.valueOf(this.upperLimit), Float.valueOf(this.redExponent), Float.valueOf(this.greenExponent), Float.valueOf(this.blueExponent), Float.valueOf(this.redScale), Float.valueOf(this.greenScale), Float.valueOf(this.blueScale));
        return result;
    }
}

